package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.declarations.DRulesetAst;

public class EPreCHRRulesetConstructor extends ASTExpression {
    DRulesetAst rulesetAst;
    
    public EPreCHRRulesetConstructor(DRulesetAst rulesetAst) {
        this.rulesetAst = rulesetAst;
        this.location = rulesetAst.location;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        CHRRuleset ruleset = rulesetAst.block.extractCHRRules(context);
        ruleset.setLocationDeep(rulesetAst.location);
        ruleset.setRulesetType(rulesetAst.type, rulesetAst.className);
        ruleset.extensible = true;
        context.getCompilationContext().module.addRuleset(rulesetAst.name, ruleset);
        ECHRRulesetConstructor result = new ECHRRulesetConstructor(ruleset);
        result.resolve(context);
        result.setType(rulesetAst.type);
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            rulesetAst.block.setLocationDeep(loc);
            location = loc;
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return this;
    }
}
