package org.simantics.scl.compiler.constants.singletons;

import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Throw2;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ThrowFunction extends FunctionValue {

    private static final TVar A = Types.var(Kinds.STAR);
    private static final TVar B = Types.var(Kinds.STAR);
    public static final ThrowFunction INSTANCE = 
            new ThrowFunction();
    
    private ThrowFunction() {
        super(new TVar[] {A, B}, Types.PROC, B, A);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        mb.pushBoxed(parameters[0]);
        mb.throwObject();
        return getReturnType();
    }

    @Override
    public String toString() {
         return "throw";
    }
    
    @Override
    public void inline(SSASimplificationContext context, LetApply apply) {
        if(apply.getParameters().length != 1)
            return; // shouldn't be possible
        
        SSABlock block = apply.getParent();
        for(SSAStatement statement=apply.getNext();statement != null;statement=statement.getNext())
            statement.destroy();
        apply.getFunction().remove();
        apply.detachThisAndSuccessors();
        block.getExit().destroy();
        block.setExit(new Throw2(apply.lineNumber, apply.getParameters()[0]));
        context.markModified("inline-throw");
    }
}
