/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.widget;

import java.util.List;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.PropertyWidgetManager;
import org.simantics.utils.datastructures.Pair;

public class ButtonSelectionListener implements SelectionListener {

    private WidgetData wd;
    private List<Pair<WidgetData, ICommand>> data;

    public ButtonSelectionListener(WidgetData wd, List<Pair<WidgetData, ICommand>> data) {
        this.wd = wd;
        this.data = data;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        widgetDefaultSelected(e);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {

        CommandContextMutable context = new CommandContextImpl();
        context.putValue("event", "onPress");

        if(!data.isEmpty()) {
            ((SWTDocument)wd.document).handleCommands(data, context, e.widget);
        }

        PropertyWidgetManager.sendEvent((SWTDocument)wd.document, wd, "onPress", e.widget, context);

    }

}