/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.URLItem;
import org.simantics.document.linking.report.evaluator.AlignmentHint;
import org.simantics.document.linking.report.evaluator.Date;
import org.simantics.document.linking.report.evaluator.Lines;
import org.simantics.document.linking.report.evaluator.Or;
import org.simantics.document.linking.report.evaluator.TextSizeHint;
import org.simantics.document.linking.report.evaluator.Variable;
import org.simantics.document.linking.report.templates.CustomizableContentProvider;
import org.simantics.document.linking.report.templates.Messages;
import org.simantics.document.linking.report.templates.TableReportWriter;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;
import org.simantics.document.linking.report.templates.custom.EvaluatorCustomizableContent;

public abstract class DocumentWriter<T>
extends TableReportWriter<T>
implements CustomizableContentProvider {
    Map<String, CustomizableContent> content = new HashMap<String, CustomizableContent>();
    ReadGraph graph;
    DocumentResource doc;
    Document document;
    Map<Object, Object> context;

    public DocumentWriter() {
        this.setDefaultContent(null);
    }

    @Override
    public void start(ReadGraph graph, Resource model, Document writer, Map<Object, Object> context) throws Exception {
        this.graph = graph;
        this.doc = DocumentResource.getInstance((ReadGraph)graph);
        this.context = context;
        this.document = writer;
    }

    @Override
    public CustomizableContent getContent(String id) {
        return this.content.get(id);
    }

    @Override
    public void setContent(String id, CustomizableContent content) {
        this.content.put(id, content);
    }

    @Override
    public void setDefaultContent(String id) {
        if ("Document".equals(id) || id == null) {
            EvaluatorCustomizableContent c = new EvaluatorCustomizableContent("Document format");
            Or item = new Or();
            item.addChild(new Variable("#HasLabel"));
            item.addChild(new Variable("#HasName"));
            c.setItem(item);
            c.setSupportStyles(false);
            c.setSupportMultiline(true);
            this.content.put("Document", c);
        }
        if ("Title".equals(id) || id == null) {
            EvaluatorCustomizableContent e = new EvaluatorCustomizableContent("Document Title");
            Lines lines = new Lines();
            Or nameOr = new Or();
            nameOr.createChild(Variable.class).setVariableRef("#HasLabel");
            nameOr.createChild(Variable.class).setVariableRef("#HasName");
            lines.createChild(TextSizeHint.class).setTextSize(Document.TextSize.HUGE).createChild(AlignmentHint.class).setAlignment(TableColumn.Alignment.CENTER).addChild(nameOr.copy());
            lines.createChild(TextSizeHint.class).setTextSize(Document.TextSize.HUGE).createChild(AlignmentHint.class).setAlignment(TableColumn.Alignment.CENTER).createChild(Variable.class).setVariableRef("DocumentName");
            lines.createChild(TextSizeHint.class).setTextSize(Document.TextSize.LARGE).createChild(AlignmentHint.class).setAlignment(TableColumn.Alignment.CENTER).createChild(Date.class);
            e.setItem(lines);
            e.setSupportStyles(true);
            e.setSupportMultiline(true);
            this.content.put("Title", e);
        }
    }

    @Override
    public Collection<String> getContentIds() {
        return this.content.keySet();
    }

    protected TextItem getDocumentItem(Resource document) throws Exception {
        TextItem item;
        if (this.graph.isInstanceOf(document, this.doc.UrlDocument)) {
            item = this.document.newItem(URLItem.class, new String[0]);
            ((URLItem)item).setURL(new URL((String)this.graph.getRelatedValue(document, this.doc.HasUrl)));
        } else {
            item = this.document.newItem(TextItem.class, new String[0]);
        }
        item.setText(this.getContent("Document").getContent(this.graph, document, this.context));
        return item;
    }

    protected TextItem getNonExistingDocumentItem() throws Exception {
        TextItem item = this.document.newItem(TextItem.class, new String[0]);
        item.setText(Messages.DocumentWriter_DocumentDoesNotExist);
        return item;
    }
}

