/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.templates.DocumentWriter;
import org.simantics.document.linking.report.templates.Messages;
import org.simantics.document.linking.report.templates.NestedComparator;
import org.simantics.document.linking.report.templates.ResourceNameComparator;
import org.simantics.document.linking.report.templates.SourceParentDiagramComparator;
import org.simantics.document.linking.report.templates.SourceReferenceComparator;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.modeling.ModelingResources;

public class DiagramStructureWriter
extends DocumentWriter<Resource> {
    ReadGraph graph;
    Resource model;
    Map<Object, Object> context;
    DocumentLink sl;
    ModelingResources mod;
    DocumentResource doc;
    NestedComparator<Resource> diagramDocumentComparator;
    ResourceNameComparator diagramComparator;

    @Override
    public String getName() {
        return "Diagram structure";
    }

    @Override
    public void start(ReadGraph graph, Resource model, Document lineWriter, Map<Object, Object> context) throws Exception {
        super.start(graph, model, lineWriter, context);
        this.context = context;
        DocumentTitlePage titlePage = lineWriter.newElement(DocumentTitlePage.class, new String[0]);
        titlePage.writeTitle(graph, context);
        Table table = lineWriter.newElement(Table.class, new String[0]);
        table.addColumn("Name", 0.4);
        table.addColumn("Document", 0.6);
        this.graph = graph;
        this.sl = DocumentLink.getInstance((ReadGraph)graph);
        this.mod = ModelingResources.getInstance((ReadGraph)graph);
        this.doc = DocumentResource.getInstance((ReadGraph)graph);
        this.model = model;
        this.diagramComparator = new SourceParentDiagramComparator(graph, model);
        this.diagramDocumentComparator = new NestedComparator();
        this.diagramDocumentComparator.addComparator(this.diagramComparator);
        this.diagramDocumentComparator.addComparator(new SourceReferenceComparator(graph, model));
        this.clearProviders();
        this.addCellProvider(new HierarchyContentProvider());
        this.addCellProvider(new DocumentContentProvider());
    }

    @Override
    public List<Resource> getReportItems(ReadGraph graph) throws Exception {
        Instances instancesQuery = (Instances)graph.adapt(this.sl.Source, Instances.class);
        Collection found = instancesQuery.find(graph, this.model);
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource source : found) {
            Resource parent = graph.getSingleObject(source, this.sl.hasSource_Inverse);
            if (!graph.hasStatement(parent, this.mod.CompositeToDiagram)) continue;
            list.add(source);
        }
        Collections.sort(list, this.diagramDocumentComparator);
        return list;
    }

    private class DocumentContentProvider
    implements RowContentProvider<Resource> {
        private DocumentContentProvider() {
        }

        @Override
        public void setText(Document writer, Resource previous, Resource current, Resource next, TextItem[] row) throws Exception {
            Resource document = SourceLinkUtil.getReferredDocument(DiagramStructureWriter.this.graph, current);
            row[1] = document != null ? DiagramStructureWriter.this.getDocumentItem(document) : DiagramStructureWriter.this.getNonExistingDocumentItem();
        }
    }

    private class HierarchyContentProvider
    implements RowContentProvider<Resource> {
        private HierarchyContentProvider() {
        }

        @Override
        public void setText(Document writer, Resource previous, Resource current, Resource next, TextItem[] row) throws Exception {
            boolean writeHierarchy = false;
            if (previous == null) {
                writeHierarchy = true;
            } else if (DiagramStructureWriter.this.diagramComparator.compare(previous, current) != 0) {
                writeHierarchy = true;
            }
            if (writeHierarchy) {
                Resource obj = DiagramStructureWriter.this.graph.getPossibleObject(current, DiagramStructureWriter.this.sl.hasSource_Inverse);
                row[0] = writer.newItem(TextItem.class, new String[0]);
                if (obj != null) {
                    List<Resource> path = SourceLinkUtil.getDiagramPath(DiagramStructureWriter.this.graph, DiagramStructureWriter.this.model, obj);
                    if (writer.getAvailableLines() < 2) {
                        writer.nextPage();
                    }
                    String text = "";
                    int i = 0;
                    while (i < path.size()) {
                        Resource r = path.get(i);
                        text = String.valueOf(text) + DiagramStructureWriter.this.diagramComparator.getText(r);
                        if (i < path.size() - 1) {
                            text = String.valueOf(text) + "/";
                        }
                        ++i;
                    }
                    row[0].setText(text);
                } else {
                    row[0].setText(Messages.DiagramStructureWriter_Hierarchymissing);
                }
            }
        }
    }
}

