/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.evaluator;

import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;

public class PredefinedVariables {
    public static final String root = "root";
    public static final String project = "project";
    public static final String model = "model";
    public static final String template = "template";
    public static final String current = ".";
    private static PredefinedVariables factory = new PredefinedVariables();
    Resource connectedComponent = null;

    public static PredefinedVariables getInstance() {
        return factory;
    }

    public static void setFactory(PredefinedVariables factory) {
        PredefinedVariables.factory = factory;
    }

    public static Resource getAnnotation(ReadGraph graph, Resource res) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection children = graph.getObjects(res, L0.ConsistsOf);
        Resource anno = null;
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        for (Resource child : children) {
            if (!graph.isInstanceOf(child, ANNO.Annotation)) continue;
            anno = child;
            break;
        }
        return anno;
    }

    public Resource getPredefinedResource(ReadGraph graph, Variable selection, String id) throws DatabaseException {
        Resource predefined = null;
        if (id.equals(root)) {
            predefined = graph.getRootLibrary();
        } else if (id.equals(project)) {
            predefined = (Resource)Simantics.getProject().get();
        } else if (id.equals(model)) {
            predefined = Variables.getModel((ReadGraph)graph, (Variable)selection);
        } else if (!id.equals(template) && id.equals(current)) {
            predefined = selection.getRepresents(graph);
        }
        return predefined;
    }

    public Variable getPredefinedVariable(ReadGraph graph, Variable selection, String id) throws DatabaseException {
        Resource predefined = this.getPredefinedResource(graph, selection, id);
        if (predefined == null) {
            return null;
        }
        Variable v = selection;
        if (predefined != null) {
            v = (Variable)graph.adapt(predefined, Variable.class);
        }
        return v;
    }

    public Variable getVariable(ReadGraph graph, String path, Resource converter, Variable selection) throws DatabaseException {
        if (path == null) {
            return null;
        }
        int colonInx = path.indexOf(58);
        int firstSlash = path.indexOf(47);
        int firstHash = path.indexOf(35);
        int firstFlashInx = firstSlash;
        if (firstFlashInx == -1) {
            firstFlashInx = firstHash;
        } else if (firstHash > -1 && firstHash < firstFlashInx) {
            firstFlashInx = firstHash;
        }
        String predefined = null;
        String relativePath = null;
        if (colonInx != -1 && firstFlashInx != -1 && colonInx + 1 == firstFlashInx && path.length() > firstFlashInx + 1) {
            String scheme = path.substring(0, colonInx);
            String absPath = path.substring(firstFlashInx + 1);
            if (scheme.equals("pre")) {
                int endOfPredefined1 = absPath.indexOf(47);
                int endOfPredefined2 = absPath.indexOf(35);
                if (endOfPredefined1 == -1 && endOfPredefined2 == -1) {
                    predefined = absPath;
                }
                if (endOfPredefined1 == -1 && endOfPredefined2 != -1) {
                    predefined = absPath.substring(0, endOfPredefined2);
                }
                if (endOfPredefined1 != -1 && endOfPredefined2 == -1) {
                    predefined = absPath.substring(0, endOfPredefined1);
                }
                if (endOfPredefined1 != -1 && endOfPredefined2 != -1) {
                    if (endOfPredefined2 < endOfPredefined1) {
                        endOfPredefined1 = endOfPredefined2;
                    }
                    predefined = absPath.substring(0, endOfPredefined1);
                }
                relativePath = absPath.substring(predefined.length());
            }
        }
        if (selection == null) {
            return null;
        }
        Variable v = selection;
        if (predefined != null) {
            v = this.getPredefinedVariable(graph, selection, predefined);
        }
        if (v == null) {
            return null;
        }
        Variable property = null;
        if (relativePath != null) {
            if (relativePath.startsWith("/.")) {
                relativePath = relativePath.substring(1);
            }
            property = v.browsePossible(graph, relativePath);
        } else {
            property = v.browsePossible(graph, path);
        }
        return property;
    }
}

