/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.layer0.Layer0;

/**
 * 
 * @author Antti Villberg
 */
public class IndexRootSymbolProviderFactory implements SymbolProviderFactory {
		
    Resource indexRoot;
    Resource diagram;

    public IndexRootSymbolProviderFactory(Resource indexRoot, Resource diagram) {
        this.indexRoot = indexRoot;
        this.diagram = diagram;
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((diagram == null) ? 0 : diagram.hashCode());
		result = prime * result + ((indexRoot == null) ? 0 : indexRoot.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		IndexRootSymbolProviderFactory other = (IndexRootSymbolProviderFactory) obj;
		if (diagram == null) {
			if (other.diagram != null)
				return false;
		} else if (!diagram.equals(other.diagram))
			return false;
		if (indexRoot == null) {
			if (other.indexRoot != null)
				return false;
		} else if (!indexRoot.equals(other.indexRoot))
			return false;
		return true;
	}

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return g.syncRequest(new LoadRequest(indexRoot, diagram));
    }

    static class LoadRequest extends BinaryRead<Resource, Resource, ISymbolProvider> {
        public LoadRequest(Resource contribution, Resource diagram) {
            super(contribution, diagram);
        }
        @Override
        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
        	
        	Layer0 L0 = Layer0.getInstance(graph);
            DiagramResource dr = DiagramResource.getInstance(graph);
            
            Collection<ISymbolGroup> groups = new ArrayList<ISymbolGroup>();
            
            if (parameter != null) {
            	Instances query = graph.adapt(dr.SymbolReferenceLibrary, Instances.class);
            	for(Resource library : query.find(graph, parameter)) {
                    if (SymbolProviderFactories.accept(graph, dr, library, parameter2)) {
                		groups.add(BasicSymbolProviderFactory.createGroup(graph, library, L0.IsRelatedTo, parameter2));
                    }
            	}
            }

            return new SymbolProvider(groups);
        }
    }

    static class SymbolProvider extends AbstractSymbolProvider {
        public SymbolProvider(Collection<ISymbolGroup> groups) {
            super();
            setSymbolGroup(groups);
            lockGroups();
        }
    }

}
