package org.simantics.diagram.scl;

import java.awt.Color;

import org.simantics.db.Resource;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest.PickPolicy;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.gallery.GalleryItemSGNode;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class SymbolLibrary {
	
	public static ICanvasContext create(ISymbolItem item) {
		IDiagram diagram =  Diagram.spawnNew(DiagramClass.DEFAULT);
        diagram.setHint(FlowLayout.HGAP, 5.0);
        diagram.setHint(FlowLayout.VGAP, 5.0);
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        CanvasContext ctx = new CanvasContext(thread);
        initializeCanvasContext(ctx);
        IHintContext hintCtx = ctx.getDefaultHintContext();
        hintCtx.setHint(DiagramHints.KEY_DIAGRAM, diagram);
        
        ElementClass ec = item.getElementClass(diagram);
        StaticSymbol ss = ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? DefaultImages.UNKNOWN2.get() : ss.getImage();
        //ImageProxy proxy = new ImageProxy(source);
        
        IElement element = Element.spawnNew(ec);
        element.setHint(ElementHints.KEY_OBJECT, item);
        element.setHint(GalleryItemSGNode.KEY_IMAGE, source);
        diagram.addElement(element);
        
        //element.getElementClass().getSingleItem(GalleryItemSGNode.class).update(element);
        
        return ctx;
	}
	
	public static Resource getItemResource(ISymbolItem item) {
		return item.getAdapter(Resource.class);
	}
	
	 private static void initializeCanvasContext(final CanvasContext canvasContext) {
	        // Create canvas context and a layer of interactors
	        final IHintContext h = canvasContext.getDefaultHintContext();

	        // Support & Util Participants
	        canvasContext.add( new TransformUtil() );

	        canvasContext.add( new MouseUtil() );
	        canvasContext.add( new KeyUtil() );
	        canvasContext.add( new SymbolUtil() );

	        // Grid & Ruler & Background
	        h.setHint(Hints.KEY_BACKGROUND_COLOR, Color.WHITE);
	        canvasContext.add( new BackgroundPainter() );

	        // Key bindings
	        canvasContext.add( new KeyToCommand( CommandKeyBinding.DEFAULT_BINDINGS ) );

	        ////// Diagram Participants //////
	        PointerInteractor pi = new PointerInteractor(true, true, false, true, false, null);
	        pi.setBoxSelectMode(PickPolicy.PICK_INTERSECTING_OBJECTS);
	        canvasContext.add( pi );
	        canvasContext.add( new Selection() );
	        canvasContext.add( new DiagramParticipant() );
	        canvasContext.add( new ElementPainter() );
	        canvasContext.add( new ElementInteractor() );
	        canvasContext.add( new TooltipParticipant());

	        h.setHint(ElementPainter.KEY_SELECTION_FRAME_COLOR, Color.WHITE);
	        h.setHint(ElementPainter.KEY_SELECTION_CONTENT_COLOR, new Color(0.7f, 0.7f, 1.f, 0.5f));
	        h.setHint(Hints.KEY_TOOL, Hints.POINTERTOOL);

	        
	        canvasContext.assertParticipantDependencies();
	    }

}
