/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.flag;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.StringModifierFactory;
import org.simantics.layer0.Layer0;

/**
 * Makes sure that two things apply:
 * <ol>
 * <li>If a flag is joined with another flag, both flags must have the same label property</li>
 * <li>A flag's label is unique within its own diagram</li>
 * </ol> 
 * @author Tuukka Lehtonen
 */
public final class FlagStringModifierFactory implements StringModifierFactory {

    private Resource subject;

    public FlagStringModifierFactory(ReadGraph graph, Resource subject) throws DatabaseException {
        this.subject = subject;
    }

    @Override
    public StringModifier createModifier(ReadGraph graph, Resource relation, Resource property) throws DatabaseException {
//        System.out.println(NameUtils.getSafeName(graph, subject));
//        System.out.println(NameUtils.getSafeName(graph, relation));
//        System.out.println(NameUtils.getSafeName(graph, property));
        Layer0 L0 = Layer0.getInstance(graph);
        if (L0.HasLabel.equals(relation)) {
            return new FlagLabelModifier(graph, subject, relation, property);
        }
        return null;
    }

}
