/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.utils.Alignment;

/**
 * ElementHandler for text elements
 * In-line editing supported.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class TextElementHandler extends TextElementNoBounds implements InternalSize {

    private static final long serialVersionUID = 2560598115620905271L;

    public static final TextElementHandler INSTANCE         = new TextElementHandler();

    public TextElementHandler() {
        super();
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment) {
        super(originX, originY, horizontalAlignment);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth) {
        super(originX, originY, horizontalAlignment, borderWidth);
    }

    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth,
            double paddingX, double paddingY, boolean editable) {
        super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable);
    }
    
    public TextElementHandler(double originX, double originY, Alignment horizontalAlignment, double borderWidth,
			double paddingX, double paddingY, boolean editable, double scale) {
		super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable, scale);
	}
    
	public TextElementHandler(double originX, double originY, Alignment horizontalAlignment,
			Alignment verticalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable,
			double scale) {
		super(originX, originY, horizontalAlignment, verticalAlignment, borderWidth, paddingX, paddingY, editable, scale);
	}

	@Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        return calculateBounds(e, size, horizontalAlignment, verticalAlignment, scale, paddingX, paddingY);
    }
    
    public static Rectangle2D calculateBounds(
            IElement e,
            Rectangle2D size, 
            Alignment horizontalAlignment, 
            Alignment verticalAlignment,
            double scale,
            double paddingX,
            double paddingY) {
        
        TextNode node = (TextNode) e.getHint(SG_NODE);
        Rectangle2D b = e.getHint(ElementHints.KEY_BOUNDS);

        if (size == null)
            size = new Rectangle2D.Double();
        if (node != null)
            size.setRect(node.getBoundsInLocal());
        else if(b != null && ElementUtils.getHintOrDefault(e, ElementHints.KEY_RESIZABLE, false))
            size.setRect(b);
        else {
            String text = e.getHint(ElementHints.KEY_TEXT);
            Font font = e.getHint(ElementHints.KEY_FONT);
            if(text == null || font == null)
               size.setFrame(0, 0, 0, 0);
            else {
	            TextNode n= new TextNode();
	            n.init(text, font, Color.black, 0.0, 0.0, scale);
	            n.setHorizontalAlignment((byte)horizontalAlignment.ordinal());
	            n.setVerticalAlignment((byte)verticalAlignment.ordinal());
	            
	            Rectangle2D r = n.getBoundsInLocal();
	            size.setFrame(r);
	            return r;
            }
        }
        return size;
        
    }
    
    
    public static double getAlignedXCoordinate(Rectangle2D bounds, Alignment horizontalAlignment) {
        if(horizontalAlignment == Alignment.CENTER) {
            return bounds.getX() - bounds.getWidth() / 2;
        } else if(horizontalAlignment == Alignment.TRAILING) {
            return - bounds.getWidth();
        }
        return bounds.getX();
    }

}