/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

public class DirectProfileEntries extends UnaryRead<ProfileTuple, List<ProfileTuple>> {

	public DirectProfileEntries(ProfileTuple tuple) {
		super(tuple);
	}

	@Override
	public List<ProfileTuple> perform(ReadGraph graph) throws DatabaseException {
		DiagramResource dr = DiagramResource.getInstance(graph);
		List<ProfileTuple> entries = new ArrayList<>();
		Resource list = graph.getPossibleObject(parameter.getEntry(), dr.HasEntries);
		if(list == null) return entries;
		for(Resource entry : ProfileUtils.getProfileChildrenFromEntries(graph, list)) {
			entries.add(new ProfileTuple(parameter.getBaseProfile(), entry, parameter.getRuntimeDiagram()));
		}
		return entries;
	}

}
