package org.simantics.diagram.profile.view;

import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.utils.ui.ISelectionUtils;

public class AddEntriesAction extends ModelledActionImpl<Resource> {

	public AddEntriesAction(Resource configuration) {
		super(configuration);
	}
	
	public void run(final Resource runtimeDiagram) {

		ISelection selection = getParameter(DiagramResource.URIs.ProfilesView_SelectedAvailableEntries);
        final List<Resource> selectedEntries = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
        if(selectedEntries != null && !selectedEntries.isEmpty()) {
            try {
                Simantics.getSession().syncRequest(new WriteRequest() {

                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	
                    	DiagramResource DIA = DiagramResource.getInstance(graph);
                    	Resource activeProfile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
                    	Resource list = graph.getPossibleObject(activeProfile, DIA.HasEntries);
                    	
                    	for(Resource entry : selectedEntries) {
                    		OrderedSetUtils.add(graph, list, entry);
                    	}
                        
                    }

                });
            } catch (DatabaseException e) {
                e.printStackTrace();
            }
        }

	}

}
