package org.simantics.diagram.profile.view;

import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.ModifyComboListenerImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;

public class ActiveProfileModifier extends ModifyComboListenerImpl<Resource, Resource> {

	@Override
 	public void applySelection(WriteGraph graph, final Resource runtimeDiagram, final Resource profile) throws DatabaseException {
		
        VirtualGraphSupport support = Simantics.getSession().getService(VirtualGraphSupport.class);
        Simantics.getSession().asyncRequest(new WriteRequest(support.getWorkspacePersistent("profiles")) {

            @Override
            public void perform(WriteGraph graph) throws DatabaseException {

        		DiagramResource DIA = DiagramResource.getInstance(graph);
        		Resource current = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
        		if(profile.equals(current)) return;
            	
				graph.deny(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile, null, current);
				graph.claim(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile, null, profile);

				// Set this profile as the default profile for this model
				String modelURI = graph.getRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasModelURI);
				Resource model = graph.getResource(modelURI);
                graph.deny(model, DIA.HasActiveProfile);
				graph.claim(model, DIA.HasActiveProfile, profile);
				
				// Set this profile as the default profile for this diagram
				Resource configuration = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
                graph.deny(configuration, DIA.HasActiveProfile);
                graph.claim(configuration, DIA.HasActiveProfile, profile);
				
            }
            
        });
		
	}

}
