/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HashMultiMap<D,R> extends HashMap<D,List<R>> {

    private static final long serialVersionUID = 8928508639019379832L;

    public void add(D a, R b) {
        List<R> elements = get(a);
        if(elements == null) {
            elements = new ArrayList<R>(1);
            put(a, elements);
        }
        elements.add(b);
    }
    
//    public boolean remove(D a, R b) {
//        List<R> elements = get(a);
//        if(elements == null) 
//            return false;
//        if(elements.remove(b)) {
//            // This would makes in some applications
//            //if(elements.isEmpty())
//            //  remove(a);
//            return true;
//        }
//        else
//            return false;
//    }
    
}
