/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public final class VariablesImpl {

	public final static int nextSeparator(String path, int startPosition) {
		int len = path.length();
		for (int i = startPosition; i < len; ++i) {
			char c = path.charAt(i);
			if (c == '/' || c == '#')
				return i;
		}
		return -1;
	}
	
    public final static Resource getFirst(ReadGraph graph, Resource type, String path, int startPosition) throws DatabaseException {

        int position = nextSeparator(path, startPosition);
        if (position == -1) {
            Resource r = graph.getResource(path);
            if (graph.isInstanceOf(r, type))
                return r;
            return null;
        }
        
        Resource r = graph.getResource(path.substring(0, position));
        if (graph.isInstanceOf(r, type)) {
            return r;
        } else {
            return getFirst(graph, type, path, position + 1);
        }

    }

}
