/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.service.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Activation;
import org.simantics.db.layer0.service.ActivationManager;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.threads.logger.IThreadLogger;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ActivationManagerImpl implements ActivationManager, Disposable {

    Session session;
    static IThreadLogger threadLogger = ThreadLogger.getInstance();

    public ActivationManagerImpl(Session session) {
        this.session = session;
    }

    @Override
    public Collection<Activation> activate(RequestProcessor processor, final Resource r) throws DatabaseException {

        return processor.syncRequest(new Read<Collection<Activation>>() {

            @Override
            public Collection<Activation> perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance(graph);
                Layer0X L0X = Layer0X.getInstance(graph);
                ArrayList<Activation> result = new ArrayList<Activation>();
                for(Resource activation : graph.getObjects(r, L0X.HasActivation)) {
                    Activation a = graph.adapt(activation, Activation.class);
                    a.activate(graph, r);
                    result.add(a);
                }
                return result;
            }

        });

    }

    @Override
    public void dispose() {
        session = null;
    }

}
