/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class VariableProperties extends UnaryRead<Variable, Collection<Variable>> {

    public VariableProperties(Variable variable) {
        super(variable);
    }

    @Override
    public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
    	return parameter.browseProperties(graph);
    }

}
