/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.r;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.modeling.ModelingUtils;
import org.simantics.r.RResource;

public class RModelUtils {
    private static Resource createModel(WriteGraph graph, Resource type, Resource target, String name, String sclMainContents) throws DatabaseException {
        Resource model = ModelingUtils.createModel((WriteGraph)graph, (Resource)type, (Resource)target, (String)name);
        Resource conf = (Resource)graph.syncRequest((Read)new Configuration(model));
        ModelingUtils.addSCLMainToModel((WriteGraph)graph, (Resource)model, (String)"SCLMain", (String)sclMainContents);
        ModelingUtils.createLocalLibrary((WriteGraph)graph, (Resource)model, (String)"Library");
        return model;
    }

    public static Resource createRModel(final Resource target, final Path file) {
        StringBuilder sb = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String newLine = null;
                while ((newLine = reader.readLine()) != null) {
                    sb.append(newLine).append("\n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final String sclMainContents = sb.toString();
        if (!sclMainContents.isEmpty()) {
            try {
                return (Resource)Simantics.sync((WriteInterface)new WriteResultRequest<Resource>(){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        RResource R = RResource.getInstance((ReadGraph)graph);
                        String fileName = file.getFileName().toString();
                        String[] parts = fileName.split("/");
                        String modelName = parts[parts.length - 1];
                        Resource model = RModelUtils.createModel(graph, R.Model, target, modelName, sclMainContents);
                        return model;
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

