/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.r.scl.variable;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.RList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.BooleanArrayBinding;
import org.simantics.databoard.binding.impl.ByteArrayBinding;
import org.simantics.databoard.binding.impl.DoubleArrayBinding;
import org.simantics.databoard.binding.impl.IntArrayBinding;
import org.simantics.databoard.binding.impl.StringArrayBinding;
import org.simantics.databoard.type.Datatype;

public class RDataboardConversion {
    public static Datatype getDatatype(REXP rexp) throws BindingException {
        if (rexp == null) {
            return Datatypes.VOID;
        }
        if (rexp instanceof REXPDouble) {
            return Datatypes.DOUBLE_ARRAY;
        }
        if (rexp instanceof REXPInteger) {
            return Datatypes.INTEGER_ARRAY;
        }
        if (rexp instanceof REXPString) {
            return Datatypes.STRING_ARRAY;
        }
        if (rexp instanceof REXPLogical) {
            return Datatypes.BOOLEAN_ARRAY;
        }
        if (rexp instanceof REXPSymbol) {
            return Datatypes.STRING;
        }
        if (rexp instanceof REXPFactor) {
            return Datatypes.STRING_ARRAY;
        }
        if (rexp instanceof REXPRaw) {
            return Datatypes.BYTE_ARRAY;
        }
        if (rexp instanceof REXPReference) {
            return RDataboardConversion.getDatatype(((REXPReference)rexp).resolve());
        }
        if (rexp instanceof REXPList || rexp instanceof REXPNull || rexp instanceof REXPGenericVector) {
            return Datatypes.VARIANT_ARRAY;
        }
        if (rexp instanceof REXPS4) {
            return Datatypes.VARIANT;
        }
        throw new BindingException("Cannot handle REXP of type " + rexp != null ? String.valueOf(rexp.getClass().getSimpleName()) + "." : "null");
    }

    public static Object fromREXP(REXP value, Binding binding) throws BindingException {
        if (value == null) {
            return binding.createDefault();
        }
        try {
            if (binding instanceof DoubleBinding) {
                return ((DoubleBinding)binding).create(value.asDouble());
            }
            if (binding instanceof IntegerBinding) {
                return ((IntegerBinding)binding).create(value.asInteger());
            }
            if (binding instanceof ByteBinding) {
                return ((ByteBinding)binding).create((Number)value.asInteger());
            }
            if (binding instanceof StringBinding) {
                return ((StringBinding)binding).create(value.asString());
            }
            if (binding instanceof NumberBinding) {
                return ((NumberBinding)binding).create((Number)value.asDouble());
            }
            if (binding instanceof BooleanBinding) {
                return ((BooleanBinding)binding).create(value.asInteger() == 1);
            }
            if (binding instanceof VariantBinding) {
                Datatype dt = RDataboardConversion.getDatatype(value);
                if (dt != null) {
                    if (dt == Datatypes.VARIANT) {
                        return ((VariantBinding)binding).create((Binding)Bindings.OBJECT, (Object)value);
                    }
                    Binding bd = Bindings.getBinding((Datatype)dt);
                    if (bd != null) {
                        return ((VariantBinding)binding).create(bd, RDataboardConversion.fromREXP(value, bd));
                    }
                }
            } else if (binding instanceof ArrayBinding) {
                if (binding instanceof DoubleArrayBinding) {
                    return value.asDoubles();
                }
                if (binding instanceof ByteArrayBinding) {
                    return value.asBytes();
                }
                if (binding instanceof IntArrayBinding) {
                    return value.asIntegers();
                }
                if (binding instanceof StringArrayBinding) {
                    return value.asStrings();
                }
                if (binding instanceof BooleanArrayBinding) {
                    int[] values = value.asIntegers();
                    boolean[] result = new boolean[values.length];
                    int i = 0;
                    while (i < values.length) {
                        result[i] = values[i] == 1;
                        ++i;
                    }
                    return result;
                }
                ArrayBinding arrayBinding = (ArrayBinding)binding;
                if (arrayBinding.componentBinding instanceof DoubleBinding) {
                    DoubleBinding componentBinding = (DoubleBinding)arrayBinding.componentBinding;
                    double[] vs = value.asDoubles();
                    Object[] components = new Object[vs.length];
                    int i = 0;
                    while (i < vs.length) {
                        components[i] = componentBinding.create(vs[i]);
                        ++i;
                    }
                    return arrayBinding.create(components);
                }
                if (arrayBinding.componentBinding instanceof IntegerBinding) {
                    IntegerBinding componentBinding = (IntegerBinding)arrayBinding.componentBinding;
                    int[] vs = value.asIntegers();
                    Object[] components = new Object[vs.length];
                    int i = 0;
                    while (i < vs.length) {
                        components[i] = componentBinding.create(vs[i]);
                        ++i;
                    }
                    return arrayBinding.create(components);
                }
                if (arrayBinding.componentBinding instanceof StringBinding) {
                    StringBinding componentBinding = (StringBinding)arrayBinding.componentBinding;
                    String[] vs = value.asStrings();
                    Object[] components = new Object[vs.length];
                    int i = 0;
                    while (i < vs.length) {
                        components[i] = componentBinding.create(vs[i]);
                        ++i;
                    }
                    return arrayBinding.create(components);
                }
                if (arrayBinding.componentBinding instanceof NumberBinding) {
                    NumberBinding componentBinding = (NumberBinding)arrayBinding.componentBinding;
                    double[] vs = value.asDoubles();
                    Object[] components = new Object[vs.length];
                    int i = 0;
                    while (i < vs.length) {
                        components[i] = componentBinding.create((Number)vs[i]);
                        ++i;
                    }
                    return arrayBinding.create(components);
                }
                if (arrayBinding.componentBinding instanceof VariantBinding) {
                    if (value instanceof REXPNull || value.length() == 0) {
                        return arrayBinding.create();
                    }
                    VariantBinding componentBinding = (VariantBinding)arrayBinding.componentBinding;
                    Object[] components = new Object[value.length()];
                    if (value.isInteger()) {
                        int[] vs = value.asIntegers();
                        int i = 0;
                        while (i < vs.length) {
                            components[i] = componentBinding.create((Binding)Bindings.INTEGER, (Object)vs[i]);
                            ++i;
                        }
                    } else if (value.isNumeric()) {
                        double[] vs = value.asDoubles();
                        int i = 0;
                        while (i < vs.length) {
                            components[i] = componentBinding.create((Binding)Bindings.DOUBLE, (Object)vs[i]);
                            ++i;
                        }
                    } else if (value.isString()) {
                        String[] vs = value.asStrings();
                        int i = 0;
                        while (i < vs.length) {
                            components[i] = componentBinding.create((Binding)Bindings.STRING, (Object)vs[i]);
                            ++i;
                        }
                    } else if (value.isList()) {
                        RList vs = value.asList();
                        int i = 0;
                        while (i < vs.size()) {
                            components[i] = RDataboardConversion.fromREXP(vs.at(i), (Binding)componentBinding);
                            ++i;
                        }
                    }
                    return arrayBinding.create(components);
                }
            }
            throw new BindingException("Couldn't handle binding " + binding + ".");
        }
        catch (REXPMismatchException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public static REXP toREXP(Object value, Binding binding) throws BindingException {
        if (binding instanceof DoubleBinding) {
            return new REXPDouble(((DoubleBinding)binding).getValue_(value));
        }
        if (binding instanceof IntegerBinding) {
            return new REXPInteger(((IntegerBinding)binding).getValue_(value));
        }
        if (binding instanceof StringBinding) {
            return new REXPString(((StringBinding)binding).getValue(value));
        }
        if (binding instanceof NumberBinding) {
            return new REXPDouble(((NumberBinding)binding).getValue(value).doubleValue());
        }
        if (binding instanceof ArrayBinding) {
            if (binding instanceof DoubleArrayBinding) {
                return new REXPDouble((double[])value);
            }
            if (binding instanceof IntArrayBinding) {
                return new REXPInteger((int[])value);
            }
            if (binding instanceof StringArrayBinding) {
                return new REXPString((String[])value);
            }
            ArrayBinding arrayBinding = (ArrayBinding)binding;
            if (arrayBinding.componentBinding instanceof DoubleBinding) {
                DoubleBinding componentBinding = (DoubleBinding)arrayBinding.componentBinding;
                double[] vs = new double[arrayBinding.size(value)];
                int i = 0;
                while (i < vs.length) {
                    vs[i] = componentBinding.getValue_(arrayBinding.get(value, i));
                    ++i;
                }
                return new REXPDouble(vs);
            }
            if (arrayBinding.componentBinding instanceof IntegerBinding) {
                IntegerBinding componentBinding = (IntegerBinding)arrayBinding.componentBinding;
                int[] vs = new int[arrayBinding.size(value)];
                int i = 0;
                while (i < vs.length) {
                    vs[i] = componentBinding.getValue_(arrayBinding.get(value, i));
                    ++i;
                }
                return new REXPInteger(vs);
            }
            if (arrayBinding.componentBinding instanceof StringBinding) {
                StringBinding componentBinding = (StringBinding)arrayBinding.componentBinding;
                String[] vs = new String[arrayBinding.size(value)];
                int i = 0;
                while (i < vs.length) {
                    vs[i] = componentBinding.getValue(arrayBinding.get(value, i));
                    ++i;
                }
                return new REXPString(vs);
            }
            if (arrayBinding.componentBinding instanceof NumberBinding) {
                NumberBinding componentBinding = (NumberBinding)arrayBinding.componentBinding;
                double[] vs = new double[arrayBinding.size(value)];
                int i = 0;
                while (i < vs.length) {
                    vs[i] = componentBinding.getValue(arrayBinding.get(value, i)).doubleValue();
                    ++i;
                }
                return new REXPDouble(vs);
            }
        }
        throw new BindingException("Couldn't handle binding " + binding + ".");
    }
}

