/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.util.Arrays;
import org.simantics.matlablink.MatlabArray;

public class CharacterArray
extends MatlabArray {
    char[] value;
    int[] dims;

    public CharacterArray(char[] value) {
        this.value = value;
        this.dims = new int[]{1, value.length};
    }

    public CharacterArray(String stringValue) {
        this.value = stringValue.toCharArray();
        this.dims = new int[]{1, this.value.length};
    }

    public CharacterArray(int[] dims, char[] value) {
        int nelem = 1;
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            nelem *= n3;
            ++n2;
        }
        if (nelem != value.length) {
            throw new IllegalArgumentException("Array dimension and value mismatch");
        }
        this.value = value;
        this.dims = dims;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public int[] dims() {
        return this.dims;
    }

    @Override
    public boolean isCharacter() {
        return true;
    }

    @Override
    public String getStringValue() {
        return new String(this.value);
    }

    public char[] getCharacters() {
        return this.value;
    }

    public char getCharacter(int index) {
        return this.value[index];
    }

    public char getCharacter(int ... is) {
        if (is.length > this.dims.length) {
            throw new IllegalArgumentException("Too many indexes for array of dimension " + this.dims.length);
        }
        int index = 0;
        int s = 1;
        int k = 0;
        while (k < is.length) {
            index += s * is[k];
            s *= this.dims[k];
            ++k;
        }
        return this.value[index];
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CharacterArray && Arrays.equals(this.dims, ((CharacterArray)obj).dims) && Arrays.equals(this.value, ((CharacterArray)obj).value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        int i = 0;
        while (i < Math.min(this.value.length, 160)) {
            sb.append(this.value[i]);
            ++i;
        }
        if (this.value.length > 160) {
            sb.append("...");
        }
        sb.append("\"(");
        i = 0;
        while (i < this.dims.length) {
            if (i > 0) {
                sb.append("x");
            }
            sb.append(this.dims[i]);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

