/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.route.Route;
import org.simantics.district.route.Waypoint;
import org.simantics.district.route.internal.RouteImpl;
import org.simantics.district.route.internal.WaypointImpl;
import org.simantics.district.route.ontology.RouteResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutePersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutePersistence.class);
    private static Comparator<Route> ROUTE_COMPARATOR = (r1, r2) -> AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)r1.getName(), (Object)r2.getName());

    public static Resource getRouteFolder(ReadGraph graph, Resource model) throws DatabaseException {
        List diagrams = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)RouteResource.getInstance((ReadGraph)graph).RouteFolder);
        if (diagrams.size() > 0) {
            return (Resource)diagrams.get(0);
        }
        return null;
    }

    public static Resource getOrCreateRouteFolder(WriteGraph graph, Resource model) throws DatabaseException {
        Resource rf = RoutePersistence.getRouteFolder((ReadGraph)graph, model);
        if (rf == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            RouteResource RR = RouteResource.getInstance((ReadGraph)graph);
            rf = graph.newResource();
            graph.claim(rf, L0.InstanceOf, null, RR.RouteFolder);
            graph.claimLiteral(rf, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
            graph.claim(model, L0.ConsistsOf, L0.PartOf, rf);
        }
        return rf;
    }

    public static Resource createRoute(WriteGraph graph, Resource model, String label, List<Resource> waypoints) throws DatabaseException {
        Resource rf = RoutePersistence.getOrCreateRouteFolder(graph, model);
        RouteResource RR = RouteResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource route = ListUtils.create((WriteGraph)graph, (Resource)RR.Route, waypoints);
        graph.claim(rf, L0.ConsistsOf, L0.PartOf, route);
        graph.claimLiteral(route, L0.HasName, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(route, L0.HasLabel, (Object)label, (Binding)Bindings.STRING);
        LOGGER.info("Persisted route {} with label {} and waypoints {}", new Object[]{route, label, waypoints});
        return route;
    }

    public static void updateRoute(WriteGraph graph, Resource route, String label, List<Resource> waypoints) throws DatabaseException {
        List existingWaypoints;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String existingLabel = (String)graph.getPossibleRelatedValue(route, L0.HasLabel, (Binding)Bindings.STRING);
        if (!ObjectUtils.objectEquals((Object)existingLabel, (Object)label)) {
            graph.claimLiteral(route, L0.HasLabel, (Object)label, (Binding)Bindings.STRING);
        }
        if (!(existingWaypoints = ListUtils.toList((ReadGraph)graph, (Resource)route)).equals(waypoints)) {
            ListUtils.removeElements((WriteGraph)graph, (Resource)route, new HashSet(existingWaypoints));
            ListUtils.createExisting((WriteOnlyGraph)graph, (Resource)route, waypoints);
        }
        LOGGER.info("Updated route {} with label {} and waypoints {}", new Object[]{route, label, waypoints});
    }

    public static void removeRoute(WriteGraph graph, Resource route) throws DatabaseException {
        RemoverUtil.remove((WriteGraph)graph, (Resource)route);
    }

    private static String waypointLabel(String componentName, String nodeName, String address) {
        String label = componentName != null ? componentName : nodeName;
        return address != null ? String.valueOf(label) + " - " + address : label;
    }

    public static Waypoint toWaypoint(ReadGraph graph, Resource waypoint) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Set types = graph.getTypes(waypoint);
        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)waypoint);
        if (types.contains(DN.Vertex)) {
            String address = (String)graph.getPossibleRelatedValue(waypoint, DN.Vertex_HasAddress, (Binding)Bindings.STRING);
            Resource mappedComponent = DistrictNetworkUtil.getMappedComponent((ReadGraph)graph, (Resource)waypoint);
            String componentName = mappedComponent != null ? NameUtils.getSafeName((ReadGraph)graph, (Resource)mappedComponent) : null;
            return new WaypointImpl(waypoint, RoutePersistence.waypointLabel(componentName, name, address));
        }
        if (types.contains(DN.Edge)) {
            return new WaypointImpl(waypoint, NLS.bind((String)"Edge {0}", (Object)name));
        }
        LOGGER.warn("Tried to convert unrecognized resource {} to a route waypoint", (Object)waypoint);
        return null;
    }

    public static List<Waypoint> toWaypoints(ReadGraph graph, List<Resource> waypoints) throws DatabaseException {
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        for (Resource wpr : waypoints) {
            Waypoint wp = RoutePersistence.toWaypoint(graph, wpr);
            if (wp == null) continue;
            result.add(wp);
        }
        return result;
    }

    public static List<RouteImpl> findRoutes(ReadGraph graph, Resource model) throws DatabaseException {
        Resource rf;
        Resource resource = rf = model != null ? RoutePersistence.getRouteFolder(graph, model) : null;
        if (rf == null) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        RouteResource RR = RouteResource.getInstance((ReadGraph)graph);
        ArrayList<RouteImpl> routes = new ArrayList<RouteImpl>();
        for (Resource route : (Collection)graph.syncRequest((Read)new ObjectsWithType(rf, L0.ConsistsOf, RR.Route))) {
            routes.add((RouteImpl)graph.syncRequest((Read)new ModelRouteRequest(model, route)));
        }
        Collections.sort(routes, ROUTE_COMPARATOR);
        return routes;
    }

    public static RouteImpl getRoute(ReadGraph graph, Resource model, Resource route) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        RouteImpl ri = new RouteImpl((String)graph.getRelatedValue(route, L0.HasLabel, (Binding)Bindings.STRING)).backend(route).modelEntity(model).waypoints(RoutePersistence.toWaypoints(graph, ListUtils.toList((ReadGraph)graph, (Resource)route)));
        ri.waypoints().forEach(wp -> {
            WaypointImpl waypointImpl = ((WaypointImpl)wp).owner(ri);
        });
        return ri;
    }

    public static List<Resource> toResources(List<Waypoint> waypoints) {
        if (waypoints.isEmpty()) {
            return Collections.emptyList();
        }
        return waypoints.stream().map(wp -> wp.adapt(Resource.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class ActiveModelRoutesRequest
    extends UniqueRead<List<RouteImpl>> {
        public List<RouteImpl> perform(ReadGraph graph) throws DatabaseException {
            return RoutePersistence.findRoutes(graph, (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource())));
        }
    }

    public static class ModelRouteRequest
    extends ResourceRead2<RouteImpl> {
        public ModelRouteRequest(Resource model, Resource resource) {
            super(model, resource);
        }

        public RouteImpl perform(ReadGraph graph) throws DatabaseException {
            return RoutePersistence.getRoute(graph, this.resource, this.resource2);
        }
    }

    public static class ModelRoutesRequest
    extends ResourceRead<List<RouteImpl>> {
        public ModelRoutesRequest(Resource model) {
            super(model);
        }

        public List<RouteImpl> perform(ReadGraph graph) throws DatabaseException {
            return RoutePersistence.findRoutes(graph, this.resource);
        }
    }

    public static class RouteRequest
    extends ResourceRead<RouteImpl> {
        public RouteRequest(Resource resource) {
            super(resource);
        }

        public RouteImpl perform(ReadGraph graph) throws DatabaseException {
            Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(this.resource));
            return model != null ? RoutePersistence.getRoute(graph, model, this.resource) : null;
        }
    }
}

