/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.geotools.referencing.CRS;
import org.simantics.district.imports.CSVImportModel;
import org.simantics.district.network.ui.DynamicComboFieldEditor;

public class CSVImportWizardPage
extends WizardPage {
    private CSVImportModel model;
    private Map<Integer, String> headerIndexAndValues = new HashMap<Integer, String>();
    private Table headerTable;
    private Combo delimiterCombo;
    private TableColumnLayout tableColumnLayout;
    private Composite tableComposite;
    List<DynamicComboFieldEditor> fieldSelectors;
    private Text edgeConnectionPadding;
    private Group indexMappingGroup;
    private Composite composite;
    private Button isVertexImport;
    private Combo sourceCRSCombo;

    protected CSVImportWizardPage(CSVImportModel model) {
        super("Import CSV Data");
        this.model = model;
        this.setMessage("Select column index mappings");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.composite);
        Label label = new Label(this.composite, 0);
        label.setText("Select delimiter");
        this.delimiterCombo = new Combo(this.composite, 12);
        this.delimiterCombo.setToolTipText("Select the delimiter that is used to separate elements in the CSV file");
        String[] formats = this.model.getDelimiterFormats();
        this.delimiterCombo.setItems(formats);
        if (formats.length > 0) {
            this.delimiterCombo.select(0);
        }
        this.delimiterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDelimiterByLabel(CSVImportWizardPage.this.delimiterCombo.getItem(CSVImportWizardPage.this.delimiterCombo.getSelectionIndex()));
                CSVImportWizardPage.this.updateHeaders();
                CSVImportWizardPage.this.updateCombos();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableComposite = new Composite(this.composite, 2048);
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        label = new Label(this.composite, 0);
        label.setText("Select source Coordinate Reference System");
        this.sourceCRSCombo = new Combo(this.composite, 0);
        this.sourceCRSCombo.setToolTipText("Select the coordinate reference system that is used in the source material for possible transformation to target coordinate reference system (EPSG:4326)");
        final Set codes = CRS.getSupportedCodes((String)"EPSG");
        this.sourceCRSCombo.setItems(codes.toArray(new String[codes.size()]));
        this.sourceCRSCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String current = CSVImportWizardPage.this.sourceCRSCombo.getItem(CSVImportWizardPage.this.sourceCRSCombo.getSelectionIndex());
                CSVImportWizardPage.this.model.setSourceCRS("EPSG:" + current);
            }
        });
        this.sourceCRSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String currentText = CSVImportWizardPage.this.sourceCRSCombo.getText();
                if (codes.contains(currentText)) {
                    String[] items = CSVImportWizardPage.this.sourceCRSCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        String item = items[i];
                        if (currentText.equals(item)) break;
                        ++i;
                    }
                    if (i != 0) {
                        CSVImportWizardPage.this.sourceCRSCombo.select(i);
                        CSVImportWizardPage.this.model.setSourceCRS("EPSG:" + currentText);
                    } else {
                        System.err.println("this should not happen");
                    }
                }
            }
        });
        this.isVertexImport = new Button(this.composite, 32);
        this.isVertexImport.setText("File contains vertices");
        this.isVertexImport.setToolTipText("Enable this if the file contains vertices, i.e. points");
        this.isVertexImport.setSelection(this.model.isVertexImport());
        this.isVertexImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setVertexImport(CSVImportWizardPage.this.isVertexImport.getSelection());
                CSVImportWizardPage.this.updateControls(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateControls(true);
        this.updateHeaders();
        this.setControl((Control)this.composite);
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (CSVImportWizardPage.this.isCurrentPage()) {
                        CSVImportWizardPage.this.updateControls(false);
                    }
                }
            });
        }
        this.validatePageComplete();
    }

    private void updateControls(boolean initial) {
        this.createIndexMappingGroup();
        this.updateCombos();
        if (!initial) {
            this.composite.layout(true, true);
        }
    }

    private void createIndexMappingGroup() {
        if (this.indexMappingGroup != null) {
            this.indexMappingGroup.dispose();
        }
        this.indexMappingGroup = new Group(this.composite, 0);
        this.indexMappingGroup.setText("Column index mapping");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.indexMappingGroup);
        this.fieldSelectors = new ArrayList<DynamicComboFieldEditor>();
        this.createCommonIndexMappingField(this.indexMappingGroup);
        if (this.model.isVertexImport()) {
            this.createVertexIndexMappingField(this.indexMappingGroup);
        } else {
            this.createEdgeIndexMappingField(this.indexMappingGroup);
        }
        if (!this.model.isVertexImport()) {
            Label label = new Label((Composite)this.indexMappingGroup, 0);
            label.setText("Connection point padding");
            GridDataFactory.fillDefaults().applyTo((Control)label);
            this.edgeConnectionPadding = new Text((Composite)this.indexMappingGroup, 2048);
            GridDataFactory.fillDefaults().applyTo((Control)this.edgeConnectionPadding);
            this.edgeConnectionPadding.setText("0.0001");
            this.edgeConnectionPadding.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        double padding = Double.parseDouble(CSVImportWizardPage.this.edgeConnectionPadding.getText());
                        CSVImportWizardPage.this.model.setEdgePadding(padding);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
        }
    }

    private void createCommonIndexMappingField(Group parent) {
        this.fieldSelectors.add(this.createComboField("componentMapping", "Apros component mapping", arg_0 -> ((CSVImportModel)this.model).setComponentMappingIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("id", "ID", arg_0 -> ((CSVImportModel)this.model).setIdIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("regionValue", "Region", arg_0 -> ((CSVImportModel)this.model).setRegionIndex(arg_0), parent));
    }

    private DynamicComboFieldEditor createComboField(String name, String label, Consumer<Integer> setter, Group parent) {
        DynamicComboFieldEditor selector = new DynamicComboFieldEditor(name, label, (Composite)parent);
        this.createSelectionListener(selector, setter);
        return selector;
    }

    private void createSelectionListener(final DynamicComboFieldEditor editor, final Consumer<Integer> setter) {
        editor.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                setter.accept(Integer.parseInt(editor.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void createVertexIndexMappingField(Group parent) {
        this.fieldSelectors.add(this.createComboField("xCoord", "X Coordinate", arg_0 -> ((CSVImportModel)this.model).setXCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("yCoord", "Y Coordinate", arg_0 -> ((CSVImportModel)this.model).setYCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("zValue", "Z Value", arg_0 -> ((CSVImportModel)this.model).setZCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("altElevation", "Alternative Elevation", arg_0 -> ((CSVImportModel)this.model).setAltElevationIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("tempValue", "Supply Temperature value", arg_0 -> ((CSVImportModel)this.model).setSupplyTempIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("returnTempValue", "Return Temperature value", arg_0 -> ((CSVImportModel)this.model).setReturnTempIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("pressureValue", "Supply Pressure value", arg_0 -> ((CSVImportModel)this.model).setSupplyPressureIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("returnPressureValue", "Return Pressure value", arg_0 -> ((CSVImportModel)this.model).setReturnPressureIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("dpValue", "Delta pressure ", arg_0 -> ((CSVImportModel)this.model).setDeltaPressureIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("dtValue", "Delta temperature ", arg_0 -> ((CSVImportModel)this.model).setDeltaTemperatureIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("heatPowerValue", "Heat Power", arg_0 -> ((CSVImportModel)this.model).setHeatPowerIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("peakPowerValue", "Peak Power", arg_0 -> ((CSVImportModel)this.model).setPeakPowerIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("nominalHeadMValue", "nominalHeadM", arg_0 -> ((CSVImportModel)this.model).setNominalHeadMIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("nominalHeadBValue", "nominalHeadB", arg_0 -> ((CSVImportModel)this.model).setNominalHeadBIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("nominalFlowValue", "nominalFlow", arg_0 -> ((CSVImportModel)this.model).setNominalFlowIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("maximumHeadMValue", "maximumHeadM", arg_0 -> ((CSVImportModel)this.model).setMaximumHeadMIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("heatLoadDsValue", "heatLoadDs", arg_0 -> ((CSVImportModel)this.model).setHeatLoadDsIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("massFlowValue", "massFlow", arg_0 -> ((CSVImportModel)this.model).setMassFlowIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("volFlowValue", "volFlow", arg_0 -> ((CSVImportModel)this.model).setVolFlowIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("velocityValue", "velocity", arg_0 -> ((CSVImportModel)this.model).setVelocityIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("flowAreaValue", "flowArea", arg_0 -> ((CSVImportModel)this.model).setFlowAreaIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("nominalPressureLossValue", "nominalPressureLoss", arg_0 -> ((CSVImportModel)this.model).setNominalPressureLossIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("valvePositionSelectorValue", "valvePositionSelector", arg_0 -> ((CSVImportModel)this.model).setValvePositionIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("addressValue", "addressSelector", arg_0 -> ((CSVImportModel)this.model).setAddressIndex(arg_0), parent));
    }

    private void createEdgeIndexMappingField(Group parent) {
        this.fieldSelectors.add(this.createComboField("startxCoord", "Start X Coordinate", arg_0 -> ((CSVImportModel)this.model).setStartXCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("startyCoord", "Start Y Coordinate", arg_0 -> ((CSVImportModel)this.model).setStartYCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("startzValue", "Start Z Value", arg_0 -> ((CSVImportModel)this.model).setStartZCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("endxCoord", "End X Coordinate", arg_0 -> ((CSVImportModel)this.model).setEndXCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("endyCoord", "End Y Coordinate", arg_0 -> ((CSVImportModel)this.model).setEndYCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("endzValue", "End Z Value", arg_0 -> ((CSVImportModel)this.model).setEndZCoordIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("pipeCodeValue", "Pipe Code", arg_0 -> ((CSVImportModel)this.model).setPipeCodeIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("detailedGeometryValue", "Geometry", arg_0 -> ((CSVImportModel)this.model).detailedGeometryIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("diameterValue", "Diameter value", arg_0 -> ((CSVImportModel)this.model).setDiameterIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("outerDiameterValue", "Outer Diameter value", arg_0 -> ((CSVImportModel)this.model).setOuterDiameterIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("nominalMassFlowValue", "Nominal Mass Flow", arg_0 -> ((CSVImportModel)this.model).setNominalMassFlowIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("edgeFlowAreaValue", "Flow Area", arg_0 -> ((CSVImportModel)this.model).setEdgeFlowAreaIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("kReturnValue", "K Return", arg_0 -> ((CSVImportModel)this.model).setKReturnIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("kSupplyValue", "K Supply", arg_0 -> ((CSVImportModel)this.model).setKSupplyIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("tGroundValue", "Temperature Ground", arg_0 -> ((CSVImportModel)this.model).setTGroundIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("lengthValue", "Length", arg_0 -> ((CSVImportModel)this.model).setLengthIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("pipeSizeDNValue", "Pipe Size DN", arg_0 -> ((CSVImportModel)this.model).setPipeSizeDNIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("structureValue", "Structure", arg_0 -> ((CSVImportModel)this.model).setStructureIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("installationYearValue", "Installation Year", arg_0 -> ((CSVImportModel)this.model).setInstallationYearIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("wallThicknessValue", "Wall Thickness", arg_0 -> ((CSVImportModel)this.model).setWallThicknessIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("insulationConductivityValue", "Insulation Conductivity", arg_0 -> ((CSVImportModel)this.model).setInsulationConductivityIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("roughnessValue", "Roughness", arg_0 -> ((CSVImportModel)this.model).setRoughnessIndex(arg_0), parent));
        this.fieldSelectors.add(this.createComboField("conductanceValue", "Conductance", arg_0 -> ((CSVImportModel)this.model).setConductanceIndex(arg_0), parent));
    }

    private void updateCombos() {
        String[][] namesAndValues = new String[this.headerIndexAndValues.size() + 1][];
        namesAndValues[0] = new String[]{"", "-1"};
        int i = 1;
        for (Map.Entry<Integer, String> entry : this.headerIndexAndValues.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            String[] nameAndValue = new String[]{value, Integer.toString(key)};
            namesAndValues[i++] = nameAndValue;
        }
        this.updateCombos(namesAndValues);
    }

    private void updateCombos(String[][] namesAndValues) {
        this.fieldSelectors.forEach(s -> s.updateCombo(namesAndValues));
    }

    private void updateHeaders() {
        if (this.headerTable != null) {
            this.headerTable.dispose();
        }
        this.headerTable = new Table(this.tableComposite, 0);
        this.headerTable.setHeaderVisible(true);
        this.headerTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.tableComposite);
        int i = 0;
        while (i < this.headerTable.getColumns().length) {
            TableColumn column = this.headerTable.getColumns()[i];
            column.dispose();
            ++i;
        }
        i = 0;
        while (i < this.headerTable.getItemCount()) {
            TableItem item = this.headerTable.getItem(i);
            item.dispose();
            ++i;
        }
        this.headerIndexAndValues.clear();
        try {
            List rows = this.model.getRows(5, false);
            int k = 0;
            while (k < rows.size()) {
                CSVRecord row = (CSVRecord)rows.get(k);
                int columnCount = row.size();
                int i2 = 0;
                while (i2 < columnCount) {
                    String value = row.get(i2);
                    if (k == 0) {
                        TableColumn headerCol = new TableColumn(this.headerTable, 0);
                        headerCol.setText(value);
                        this.tableColumnLayout.setColumnData((Widget)headerCol, (ColumnLayoutData)new ColumnWeightData(10));
                        headerCol.pack();
                        this.headerIndexAndValues.put(i2, value);
                    } else {
                        int actualK = k - 1;
                        int itemCount = this.headerTable.getItemCount();
                        TableItem item = actualK >= itemCount ? new TableItem(this.headerTable, 0) : this.headerTable.getItem(actualK);
                        item.setText(i2, value);
                    }
                    ++i2;
                }
                ++k;
            }
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected void validatePageComplete() {
        if (this.model.isVertexImport()) {
            this.setPageComplete(this.model.getXCoordIndex() != -1 && this.model.getYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        } else {
            this.setPageComplete(this.model.getStartXCoordIndex() != -1 && this.model.getStartYCoordIndex() != -1 && this.model.getEndXCoordIndex() != -1 && this.model.getEndYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        }
    }
}

