/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.contributions;

import java.util.Map;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.workbench.internal.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class DumpStackTracesButtonTrim extends Composite {

    LocalResourceManager resourceManager;

    private final Button b;
    private final Clipboard clipboard;

    public DumpStackTracesButtonTrim(Composite parent) {
        super(parent, SWT.NONE);

        setLayout(new FillLayout());

        this.b = new Button(this, SWT.PUSH);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), b);
        this.clipboard = new Clipboard(parent.getDisplay());

        b.setToolTipText("Dump thread stack traces to clipboard");
        b.setImage(resourceManager.createImage(Activator.getImageDescriptor("img/page_white_paste_table.png")));
        b.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                dumpStackTraces();
            }
        });

        b.addDisposeListener(new DisposeListener() {
            @Override
            public void widgetDisposed(DisposeEvent e) {
                clipboard.dispose();
            }
        });
    }

    protected void dumpStackTraces() {
        StringBuilder text = new StringBuilder();
        //StringBuilder rtf = new StringBuilder();

        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] trace = entry.getValue();
            text.append(thread.toString());
            text.append('\n');
            for (StackTraceElement element : trace) {
                text.append('\t');
                text.append(element.toString());
                text.append('\n');
            }
            text.append('\n');
        }

        clipboard.setContents(new Object[] { text.toString() }, new Transfer[] { TextTransfer.getInstance() });
    }

}