/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx.clipboard.headers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;



/**
 * WIN32 API BITMAPFILEHEADER
 * 
 * @see http://msdn.microsoft.com/library/default.asp?url=/library/en-us/gdi/bitmaps_62uq.asp
 * @author Marko Luukkainen
 *
 */
public class BitmapFileHeader {
    public short bfType;
    public int bfSize;
    public short bfReserved1;
    public short bfReserved2;
    public int bfOffBits;
    public static final int sizeof = 14;
    
    /**
     * Creates BITMAPFILEHEADER for bitmap that has
     * BITMAPINFO.bmiColors field NULL / undefined 
     *
     */
    public BitmapFileHeader() {
        bfType = 'B';
        bfType <<= 8;
        bfType |= (0xff & 'M');
        bfSize = 0;
        bfReserved1 = 0;
        bfReserved2 = 0;
        bfOffBits = sizeof + BitmapInfoHeader.sizeof;
    
    }
    
    public byte[] getBytes() {
        byte [] array = new byte[sizeof];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort(bfType);
        buffer.putInt(bfSize);
        buffer.putShort(bfReserved1);
        buffer.putShort(bfReserved2);
        buffer.putInt(bfOffBits);
        return array;
    }
}
