/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.color;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/**
 * 
 * Canvas that shows color gradients
 * 
 * @author Marko Luukkainen
 *
 */
public class ColorCanvas extends Canvas{
	Color color;
	int style;
	
	public ColorCanvas(Composite parent, int style) {
		// FIXME : use xor operation to get SWT.HORIZONTAL and SWT.VERTICAL
		// out of style when it's passed to parent
		super(parent,SWT.BORDER);
		this.style = style & (SWT.VERTICAL | SWT.HORIZONTAL) ;
		addPaintListener(new PaintListener() {
	    	public void paintControl(PaintEvent e) {
	    		GC gc = e.gc;
	    		Rectangle clip = gc.getClipping();
	    		if (color != null) {
	    			Image image = ColorIconCreator.createImage(color, clip.width,clip.height);
	    			gc.drawImage(image, 0, 0);
	    			image.dispose();		
	    		} else {
	    			gc.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	    			gc.fillRectangle(clip);
	    		}
	    	}
	    });
	}
	
	public void setColor(Color color) {
		this.color = color;
		this.redraw();
	}		

}
