/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.threads.internal;

/**
 * A generic Pair (2-tuple) structure for containing two object instances of
 * chosen types.
 * 
 * @param <T1> type of first element
 * @param <T2> type of second element
 */
public final class Pair<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public Pair(T1 first, T2 second) {
        assert(first != null);
        assert(second != null);
        
        this.first = first;
        this.second = second;
        this.hash = makeHash();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj.getClass().equals(this.getClass())))
            return false;
        Pair<?, ?> other = (Pair<?, ?>) obj;
        if (other.first != first && !other.first.equals(first))
            return false;
        if (other.second != second && !other.second.equals(second))
            return false;
        return true;
    }
    
    @Override
    public int hashCode() {
        return hash;
    }
    
    @Override
    public String toString() {
        return "<"+first+", "+second+">";
    }
    
    private int makeHash() {
        return first.hashCode() ^ second.hashCode()*7;
    }
}
