/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;

import org.simantics.utils.threads.internal.Pair;


/**
 * Thread manager
 * 
 * TODO Replace with ScheduledThreadPoolExecutor
 */
public class WorkerThread extends Thread implements IThreadWorkQueue {

    LinkedList<Pair<Runnable, Semaphore>> list         = new LinkedList<Pair<Runnable, Semaphore>>();

    boolean                               stop         = false;

    Semaphore                             finishPermit = new Semaphore(0);

    public WorkerThread() {
        super();
    }
    
    public WorkerThread(String name) {
        super(name);
    }
    
    public void stopDispatchingEvents(boolean blockUntilCompleted) {
        synchronized (this) {
            stop = true;
            notify();
        }
        if (blockUntilCompleted) {
            try {
                finishPermit.acquire();
            } catch (InterruptedException e) {
            }
        }
    }

    @Override
    public void run() {
        try {
            while (!stop) {
                while (true) {
                    Pair<Runnable, Semaphore> p = null;
                    synchronized (this) {
                        if(list.isEmpty())
                            break;
                        p = list.pop();
                    }                                         
                    Runnable r = p.first;
                    try {
                        r.run();
                    } catch (RuntimeException rte) {
                        rte.printStackTrace();
                    }
                    if (p.second != null)
                        p.second.release(1);
                }
                synchronized (this) {
                    if (!stop)
                        try {
                            wait(10000L);
                        } catch (InterruptedException e) {
                        }
                }
            }
        } finally {
            finishPermit.release();
        }
    }

    @Override
    public boolean syncExec(Runnable runnable) {
        Semaphore s = new Semaphore(0);
        synchronized (this) {
            if (stop)
                return false;
            Pair<Runnable, Semaphore> p = new Pair<Runnable, Semaphore>(runnable, s);
            list.addFirst(p);
            notify();
        }
        return true;
    }

    @Override
    public synchronized Thread asyncExec(Runnable runnable) {
        if (stop)
            return null;
        Pair<Runnable, Semaphore> p = new Pair<Runnable, Semaphore>(runnable, new Semaphore(0));
        list.addLast(p);
        notify();
        return this;
    }

    @Override
    public boolean currentThreadAccess() {
        return Thread.currentThread() == this;
    }

    @Override
    public Thread getThread() {
        return this;
    }

}
