/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads;

import java.util.concurrent.Executor;


/**
 * No thread switching
 * 
 * @Todo Rename to InvokerWorks
 */
public class CurrentThread implements IThreadWorkQueue, Executor {

	static CurrentThread INSTANCE = new CurrentThread();
	
	public static IThreadWorkQueue getThreadAccess()
	{
		return INSTANCE;
	}
	
	CurrentThread() {}
	
	@Override
	public Thread asyncExec(Runnable runnable) {
		runnable.run();
		return Thread.currentThread();
	}

	@Override
	public boolean syncExec(Runnable runnable) {
		runnable.run();
		return true;
	}

	@Override
	public boolean currentThreadAccess() {
		return true;
	}

	@Override
	public Thread getThread() {
		return Thread.currentThread();
	}
	
	@Override
	public String toString() {
		return "Current thread";
	}

	@Override
	public void execute(Runnable command) {
		command.run();
	}
}
