package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

public class MaxFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
          Double max = Double.MIN_VALUE;
          for (AstValue value : args.values) {
              Object result = value.accept(visitor);
              if (result instanceof SpreadsheetMatrix) {
                  Object value2 = ((SpreadsheetMatrix) result).maxWithFormulaError();
                  if(value2 instanceof String) return value2;
                  double d = ((Number)value2).doubleValue();
                  if(d > max)
                      max = d;
              } else if(result instanceof String && !result.equals("")){
                  FormulaError2 error = FormulaError2.forString(result.toString());
                  if(error!=null) return error.getString();
                  Double d = Spreadsheets.asDoubleWhereEmptyStringIsZero(result);
                  if(d != null)
                      if(d > max)
                          max = d;
              } else if(result instanceof Number){
                  double d = ((Number)result).doubleValue(); 
                  if(d > max)
                      max = d;
              } else {
                  double d = Spreadsheets.asNumber(result); 
                  if(d > max)
                      max = d;
              }
          }
          return max;
    }

}
