package org.simantics.simulation.ui.handlers.e4;

import java.text.ParseException;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.simulation.experiment.SimulationTimeUtil;

/**
 * @author Tuukka Lehtonen
 */
public class TimeInputDialog extends InputDialog {

    private Text statusText;

    public TimeInputDialog(Shell parentShell, String dialogTitle, String topic, String initialValue) {
        super(parentShell, dialogTitle, message(topic), initialValue, new TimeValidator());
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);

        statusText = new Text(composite, SWT.READ_ONLY | SWT.WRAP);
        statusText.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
                | GridData.HORIZONTAL_ALIGN_FILL));

        return composite;
    }

    @Override
    protected void validateInput() {
        super.validateInput();

        try {
            double t = (double) SimulationTimeUtil.getTimeFormat().parseObject(getText().getText());
            statusText.setText(statusMessage(t));
        } catch (ParseException e) {
            statusText.setText("");
        }
    }

    private static String message(String topic) {
        return NLS.bind("Give {0} in seconds or timestamp format ([Yy] [Dd] HH:mm:ss.ddd)", topic);
    }

    private static String statusMessage(double time) {
        return NLS.bind(
                "Specified time is {0} s ({1})",
                SimulationTimeUtil.formatSeconds(time),
                SimulationTimeUtil.formatHMSS(time));
    }

}
