/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers.e4;

import javax.inject.Inject;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.SimulationEvents;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;
import org.simantics.simulation.ui.preferences.SimulationPreferences.StepMode;
import org.simantics.utils.ui.ExceptionUtils;

public class SetDuration {

    private static final String SET_DURATION_ITEM_ID = "org.simantics.simulation.ui.handledmenuitem.setduration";

    @Inject
    private EModelService modelService;

    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(MMenuItem item) {
        // This is a radio menu item, execute is called also when it is deselected
        if (!item.isSelected())
            return;

        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();

        TimeInputDialog dialog = new TimeInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
                "Set Simulation Step Duration", "simulation step duration", "" + prefs.stepDuration);
        if (dialog.open() == InputDialog.OK) {
            final double duration = Double.parseDouble(dialog.getValue());
            try {
                SimulationPreferenceUtil.flushPrefs(prefs.withDuration(duration).withStepMode(StepMode.DURATION));
                eventBroker.post(SimulationEvents.TOPIC_STEP_DURATION, duration);
                eventBroker.post(SimulationEvents.TOPIC_STEP_MODE, StepMode.DURATION);
            } catch (BackingStoreException e) {
                ExceptionUtils.logAndShowError(e);
            }
        } else {
            eventBroker.post(SimulationEvents.TOPIC_STEP_MODE, prefs.stepMode);
        }
    }

    @Inject
    @Optional
    public void updateElement(@Optional @UIEventTopic(SimulationEvents.TOPIC_STEP_MODE) StepMode mode, MApplication application) {
        WorkbenchUtil.setMenuItemSelected(modelService, application, Step.HANDLED_ITEM_ID, SET_DURATION_ITEM_ID, mode == StepMode.DURATION);
    }

}
