package org.simantics.scl.runtime.unification;

import java.util.Map;

import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;

import gnu.trove.map.hash.THashMap;

public class UMapUtils {
    public static void put(Map<Object,Object> map, Object key, Object value) {
        if(map.containsKey(key))
            Unification.unify(map.get(key), value);
        else
            map.put(key, value);
    }
    
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public static Object get(final Function def, THashMap<Object,Object> map, Object key) {
        try {
            Object value = map.get(key);
            if(value == null) {
                if(!map.containsKey(key)) {
                    value = def.apply(Tuple0.INSTANCE);
                    map.put(key, value);
                }
                return value;
            }
            else {
                Object extrValue = Unification.extractWithDefault(def, value);
                if(extrValue != value)
                    map.put(key, extrValue);
                return extrValue;
            }
        } catch(RuntimeException e) {
            throw new RuntimeException("While generating value for key " + key + ".", e);
        }
    }
}
