package org.simantics.scl.runtime.string;


public class StringEscape {

    public static String escapeJava(String str) {
        return appendEscapedString(new StringBuilder(str.length()), str).toString();
    }
    
    public static StringBuilder appendEscapedString(StringBuilder b, String str) {
        int length = str.length();
        for(int i = 0; i < length; i++) {
            char c = str.charAt(i);
            if (c < 32) {
                switch (c) {
                case '\b' :
                    b.append('\\');
                    b.append('b');
                    break;
                case '\n' :
                    b.append('\\');
                    b.append('n');
                    break;
                case '\t' :
                    b.append('\\');
                    b.append('t');
                    break;
                case '\f' :
                    b.append('\\');
                    b.append('f');
                    break;
                case '\r' :
                    b.append('\\');
                    b.append('r');
                    break;
                default :
                    if (c > 0xf)
                        b.append("\\u00" + Integer.toHexString(c));
                    else
                        b.append("\\u000" + Integer.toHexString(c));
                    break;
                }
            }
            else {
                switch (c) {
                case '"' :
                    b.append('\\').append('"');
                    break;
                case '\\' :
                    b.append('\\').append('\\');
                    break;
                default :
                    b.append(c);
                    break;
                }
            }
        }
        return b;
    }
    
    public static String unescapeJava(String str) {
        int length = str.length();
        StringBuilder b = new StringBuilder(length*3/2);
        for(int i = 0; i < length; i++) {
            char c = str.charAt(i);
            if(c == '\\') {
                ++i;
                c = str.charAt(i); // if i==length, this throws an exception, which is OK
                switch(c) {
                case 'b': b.append('\b'); break;
                case 't': b.append('\t'); break;
                case 'n': b.append('\n'); break;
                case 'f': b.append('\f'); break;
                case 'r': b.append('\r'); break;
                case 'u':
                    b.append((char)Integer.parseInt(str.substring(i+1, i+5), 16));
                    i+=4;
                    break;
                default:
                    if(c >= '0' && c <= '9') {
                        b.append(c - '0');
                    }
                    else
                        b.append(c);
                }
            }
            else
                b.append(c);
        }
        return b.toString();
    }
    
}
