package org.simantics.scl.runtime.reporting;

import java.io.Writer;

public class SCLReportingWriter extends Writer {
	
	StringBuilder builder = null;
	
	public SCLReportingWriter() {
		builder = new StringBuilder();
	}
	
	@Override
	public void close() {
		flush();
	}

	@Override
	public void flush() {
		if (builder.length() > 0) {
			SCLReporting.print(builder.toString());
			builder.setLength(0);
		}
	}

	@Override
	public void write(char[] buf, int off, int len) {
		if (len == 0) return;
		
		if (len < 0) throw new IllegalArgumentException("Negative buffer region length");
		if (off < 0) throw new IllegalArgumentException("Negative buffer region offset");
		if (off + len > buf.length) throw new IllegalArgumentException("Buffer region overflow");
		
		for (int i = 0; i < len; i++) {
			if (buf[off + i] == '\n') {
				SCLReporting.print(builder.toString());
				builder.setLength(0);
			}
			else {
				builder.append(buf[off + i]);
			}
		}
	}
}
