package org.simantics.scl.runtime.chr;

public class CHRContext {
    public CHRPriority topPriority;
    public int currentId = 0;
    
    public void activate(int maxPriority) {
        //System.out.println("--- ACTIVATE " + maxPriority + "---------------------------------------------");
        while(topPriority != null && topPriority.priority < maxPriority) {
            CHRPriority currentPriority = topPriority;
            topPriority = currentPriority.nextPriority();
            currentPriority.activate(this);
            currentPriority.inContext = false;
        }
        //System.out.println("--- FINISHED " + maxPriority + "---------------------------------------------");
    }
    
    public int generateId() {
        return currentId++;
    }
}
