/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.mapping.rule.instructions.UnlessRuleInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class UnlessRule implements IRule {

	IConstraint condition;
	IRule rule;
	
	public UnlessRule(IConstraint condition, IRule rule) {
		this.condition = condition;		
		this.rule = rule;
	}

	@Override
	public ImmutableSet<Resource> binds() {
		return condition.binds().addAll(rule.binds());
	}

	@Override
	public IRuleInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds,
			ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
		IInstruction conditionInstruction = 
			condition.createInstruction(variableIds, bound);
		bound = bound.addAll(condition.binds());
		return new UnlessRuleInstruction(conditionInstruction, 
				rule.createInstruction(variableIds, bound));
	}

}
