/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping;

import java.util.Collection;

import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.layer0.utils.triggers.ITrigger;

/**
 * Composes multiple triggers into one modification that performs
 * all modifications generated by the triggers.
 */
public class CompositeModification implements IModification {
	Collection<ITrigger> triggers;

	public CompositeModification(Collection<ITrigger> triggers) {
		this.triggers = triggers;
	}

	@Override
	public void perform(WriteGraph g) throws DatabaseException {
		for(ITrigger trigger : triggers) {
			while(true) {
				IModification modi = g.syncRequest(trigger);
				if(modi != null)
					modi.perform(g);
				else
					break;
			}
		}
	}
	
	
}
