/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jdbc.ontology;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class JDBCResource {
    public final Resource Session;
    public final Resource Session_hasValue;
    public final Resource Session_hasValue_Inverse;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public JDBCResource(ReadGraph graph) {
        this.Session = JDBCResource.getResourceOrNull(graph, "http://www.simantics.org/JDBC-1.0/Session");
        this.Session_hasValue = JDBCResource.getResourceOrNull(graph, "http://www.simantics.org/JDBC-1.0/Session/hasValue");
        this.Session_hasValue_Inverse = JDBCResource.getResourceOrNull(graph, "http://www.simantics.org/JDBC-1.0/Session/hasValue/Inverse");
    }

    public static JDBCResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        JDBCResource ret = (JDBCResource)session.peekService(JDBCResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new JDBCResource(qc.getIndependentGraph(graph));
            session.registerService(JDBCResource.class, (Object)ret);
        }
        return ret;
    }

    public static JDBCResource getInstance(RequestProcessor session) throws DatabaseException {
        JDBCResource ret = (JDBCResource)session.peekService(JDBCResource.class);
        if (ret == null) {
            ret = (JDBCResource)session.syncRequest((Read)new Read<JDBCResource>(){

                public JDBCResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new JDBCResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(JDBCResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String Session = "http://www.simantics.org/JDBC-1.0/Session";
        public static final String Session_hasValue = "http://www.simantics.org/JDBC-1.0/Session/hasValue";
        public static final String Session_hasValue_Inverse = "http://www.simantics.org/JDBC-1.0/Session/hasValue/Inverse";
    }
}

