/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.matlablink.MatlabArray;

public class StructArray
extends MatlabArray {
    int size;
    Map<String, MatlabArray[]> fields;
    int[] dims;

    public StructArray(int size, String[] fields) {
        this.size = size;
        this.dims = new int[]{1, size};
        this.fields = new HashMap<String, MatlabArray[]>();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.fields.put(name, new MatlabArray[size]);
            ++n2;
        }
    }

    public StructArray(int size, Collection<String> fields) {
        this.size = size;
        this.dims = new int[]{1, size};
        this.fields = new HashMap<String, MatlabArray[]>();
        for (String name : fields) {
            this.fields.put(name, new MatlabArray[size]);
        }
    }

    public StructArray(int[] dims, String[] fields) {
        this.dims = dims;
        int size = 1;
        Object[] objectArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectArray[n2];
            size *= n3;
            ++n2;
        }
        this.size = size;
        this.fields = new HashMap<String, MatlabArray[]>();
        objectArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            int name = objectArray[n2];
            this.fields.put((String)name, new MatlabArray[size]);
            ++n2;
        }
    }

    public StructArray(int[] dims, Collection<String> fields) {
        this.dims = dims;
        int size = 1;
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            size *= n3;
            ++n2;
        }
        this.size = size;
        this.fields = new HashMap<String, MatlabArray[]>();
        for (String name : fields) {
            this.fields.put(name, new MatlabArray[size]);
        }
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] dims() {
        return this.dims;
    }

    public String[] getFields() {
        return this.fields.keySet().toArray(new String[this.fields.size()]);
    }

    @Override
    public MatlabArray getField(int index, String fieldName) {
        MatlabArray[] value = this.fields.get(fieldName);
        return value != null ? value[index] : null;
    }

    public MatlabArray getField(String fieldName, int ... is) {
        int index = 0;
        int s = 1;
        int k = 0;
        while (k < is.length) {
            index += s * is[k];
            s *= this.dims[k];
            ++k;
        }
        return this.getField(index, fieldName);
    }

    public void setField(int index, String fieldName, MatlabArray v) {
        MatlabArray[] value = this.fields.get(fieldName);
        if (value == null) {
            value = new MatlabArray[this.size];
            value[index] = v;
            this.fields.put(fieldName, value);
        }
        value[index] = v;
    }

    public void setField(String fieldName, MatlabArray v, int ... is) {
        int index = 0;
        int s = 1;
        int k = 0;
        while (k < is.length) {
            index += s * is[k];
            s *= this.dims[k];
            ++k;
        }
        this.setField(index, fieldName, v);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StructArray && Arrays.equals(this.dims, ((StructArray)obj).dims) && StructArray.fieldsEqual(this.fields, ((StructArray)obj).fields);
    }

    private static boolean fieldsEqual(Map<String, MatlabArray[]> f1, Map<String, MatlabArray[]> f2) {
        if (!f1.keySet().equals(f2.keySet())) {
            return false;
        }
        return Arrays.deepEquals(f1.values().toArray(), f2.values().toArray());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Set<String> keys = this.fields.keySet();
        Iterator<String> iter = keys.iterator();
        int i = 0;
        while (i < this.fields.entrySet().size()) {
            String key = iter.next();
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(key);
            ++i;
        }
        sb.append(" (");
        i = 0;
        while (i < this.dims.length) {
            if (i > 0) {
                sb.append("x");
            }
            sb.append(this.dims[i]);
            ++i;
        }
        sb.append(")}");
        return sb.toString();
    }
}

