/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.util.Arrays;
import org.simantics.matlablink.MatlabArray;

public class CellArray
extends MatlabArray {
    MatlabArray[] value;
    int[] dims;

    public CellArray(int length) {
        this.value = new MatlabArray[length];
        this.dims = new int[]{1, length};
    }

    public CellArray(int ... dims) {
        int nelem = 1;
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            nelem *= n3;
            ++n2;
        }
        this.dims = dims;
        this.value = new MatlabArray[nelem];
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public int[] dims() {
        return this.dims;
    }

    public void setCellItem(int index, MatlabArray v) {
        this.value[index] = v;
    }

    @Override
    public boolean isCell() {
        return true;
    }

    @Override
    public MatlabArray[] getCellValue() {
        return this.value;
    }

    @Override
    public MatlabArray getCellItem(int index) {
        return this.value[index];
    }

    public MatlabArray getCellItem(int i, int j) {
        return this.value[i + this.dims[0] * j];
    }

    public MatlabArray getCellItem(int ... k) {
        if (k.length > this.dims.length) {
            throw new IllegalArgumentException("Too many indexes for array of dimension " + this.dims.length);
        }
        int s = 1;
        int index = 0;
        int l = 0;
        while (l < k.length) {
            index += s * k[l];
            s *= this.dims[l];
            ++l;
        }
        return this.value[index];
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CellArray && Arrays.equals(this.dims, ((CellArray)obj).dims) && Arrays.equals(this.value, ((CellArray)obj).value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < Math.min(this.size(), 10)) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.value[i]);
            ++i;
        }
        if (this.size() > 10) {
            sb.append(", ...");
        }
        sb.append(" (");
        i = 0;
        while (i < this.dims.length) {
            if (i > 0) {
                sb.append("x");
            }
            sb.append(this.dims[i]);
            ++i;
        }
        sb.append(")}");
        return sb.toString();
    }
}

