/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base.datatypes.literal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public class DateTime
extends Bean
implements org.simantics.xml.sax.base.datatypes.adt.DateTime {
    public static final Binding BINDING = Bindings.getBindingUnchecked(DateTime.class);
    public int year;
    public byte month;
    public byte day;
    public byte hours;
    public byte minutes;
    public byte seconds;
    public int offset;

    public DateTime() {
        super(BINDING);
    }

    public DateTime(int year, int month, int day, int hours, int minutes, int seconds) {
        this(year, month, day, hours, minutes, seconds, Integer.MIN_VALUE);
    }

    public DateTime(int year, int month, int day, int hours, int minutes, int seconds, int offset) {
        super(BINDING);
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException("Month must be between 1 - 12, got " + month);
        }
        if (day <= 0 || day > 31) {
            throw new IllegalArgumentException("Day must be between 1 - 31, got " + day);
        }
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Hours must be between 0 - 23, got " + hours);
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Minutes must be between 0 - 59, got " + minutes);
        }
        if (seconds < 0 || seconds > 59) {
            throw new IllegalArgumentException("Seconds must be between 0 - 59, got " + seconds);
        }
        this.year = year;
        this.month = (byte)month;
        this.day = (byte)day;
        this.hours = (byte)hours;
        this.minutes = (byte)minutes;
        this.seconds = (byte)seconds;
        this.offset = offset;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDate() {
        return this.day;
    }

    @Override
    public int getHours() {
        return this.hours;
    }

    @Override
    public int getMinutes() {
        return this.minutes;
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    @Override
    public int getTimezoneOffset() {
        return this.offset;
    }

    @Override
    public Date getJavaDate() {
        Calendar c = Calendar.getInstance();
        c.set(this.year, this.month, this.day, this.hours, this.minutes, this.seconds);
        if (this.offset != Integer.MIN_VALUE) {
            c.setTimeZone(TimeZone.getTimeZone(TimeZone.getAvailableIDs(this.offset * 60 * 1000)[0]));
        }
        return c.getTime();
    }

    @Override
    public int compare(org.simantics.xml.sax.base.datatypes.adt.DateTime o) {
        if (this.getYear() != o.getYear()) {
            return this.getYear() - o.getYear();
        }
        if (this.getMonth() != o.getMonth()) {
            return this.getMonth() - o.getMonth();
        }
        if (this.getDate() != o.getDate()) {
            return this.getDate() - o.getDate();
        }
        if (this.getHours() != o.getHours()) {
            return this.getHours() - o.getHours();
        }
        if (this.getMinutes() != o.getMinutes()) {
            return this.getMinutes() - o.getMinutes();
        }
        if (this.getSeconds() != o.getSeconds()) {
            return this.getSeconds() - o.getSeconds();
        }
        return 0;
    }

    public static DateTime parseDateTime(String dateString) {
        String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ssSSSSSSSXXX", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssSSSSSSS"};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] timezone = blArray;
        int i = 0;
        while (i < formats.length) {
            String format = formats[i];
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                Date n = dateFormat.parse(dateString);
                if (timezone[i]) {
                    return new DateTime(n.getYear() + 1900, n.getMonth() + 1, n.getDate(), n.getHours(), n.getMinutes(), n.getSeconds(), n.getTimezoneOffset());
                }
                return new DateTime(n.getYear() + 1900, n.getMonth() + 1, n.getDate(), n.getHours(), n.getMinutes(), n.getSeconds());
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        throw new IllegalArgumentException("Time is not in proper format " + dateString);
    }

    public String toString() {
        return String.valueOf(this.year) + "-" + (this.month < 10 ? "0" : "") + this.month + "-" + (this.day < 10 ? "0" : "") + this.day + "T" + (this.hours < 10 ? "0" : "") + this.hours + ":" + (this.minutes < 10 ? "0" : "") + this.minutes + ":" + (this.seconds < 10 ? "0" : "") + this.seconds;
    }
}

