/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.test.Path;
import org.simantics.interop.test.ResourceComparator;
import org.simantics.interop.test.TypeComparator;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;

public class GraphComparator {
    private static final boolean DEBUG = false;
    private Resource r1;
    private Resource r2;
    private Set<Resource> strong = new HashSet<Resource>();
    private List<Resource> traversed = new ArrayList<Resource>();
    private List<Resource> tested = new ArrayList<Resource>();
    private List<Resource> nonTraversed = new ArrayList<Resource>();
    private List<Resource> nonTested = new ArrayList<Resource>();
    private List<Statement> changes1 = new ArrayList<Statement>();
    private List<Statement> changes2 = new ArrayList<Statement>();
    private List<GraphChanges.Modification> modifications = new ArrayList<GraphChanges.Modification>();
    private Set<Statement> changes1Set = new HashSet<Statement>();
    private Set<Statement> changes2Set = new HashSet<Statement>();
    private Set<GraphChanges.Modification> modificationsSet = new HashSet<GraphChanges.Modification>();
    private BijectionMap<Statement, Statement> comparableStatements = new BijectionMap();
    private BijectionMap<Resource, Resource> comparableResources = new BijectionMap();
    private Set<Resource> processedResources = new HashSet<Resource>();
    private ResourceComparator comparator;
    private Comparator<Statement> scomp = new PredicateComparator();
    private Comparator<Resource> rcomp = new ResComparator();
    private Set<Resource> nonMatchedLeft = new HashSet<Resource>();
    private Set<Resource> nonMatchedRight = new HashSet<Resource>();
    private ReadGraph g;
    private Layer0 b;
    ArrayList<Statement> ss1 = new ArrayList();
    ArrayList<Statement> ss2 = new ArrayList();

    public GraphComparator(Resource r1, Resource r2) {
        this.r1 = r1;
        this.r2 = r2;
        this.comparator = new TypeComparator();
    }

    public GraphComparator(Resource r1, Resource r2, ResourceComparator comparator) {
        this.r1 = r1;
        this.r2 = r2;
        this.comparator = comparator;
    }

    public Comparator<Resource> getResourceComparator() {
        return this.rcomp;
    }

    public Comparator<Statement> getStatementComparator() {
        return this.scomp;
    }

    public Resource getR1() {
        return this.r1;
    }

    public Resource getR2() {
        return this.r2;
    }

    public void addTraversed(Resource rel) {
        this.traversed.add(rel);
    }

    public void addTraversed(Collection<Resource> rels) {
        this.traversed.addAll(rels);
    }

    public void addNonTraversed(Resource rel) {
        this.nonTraversed.add(rel);
    }

    public void addNonTraversed(Collection<Resource> rels) {
        this.nonTraversed.addAll(rels);
    }

    public void addTested(Resource rel) {
        this.tested.add(rel);
    }

    public void addTested(Collection<Resource> rels) {
        this.tested.addAll(rels);
    }

    public void addNonTested(Resource rel) {
        this.nonTested.add(rel);
    }

    public void addNonTested(Collection<Resource> rels) {
        this.nonTested.addAll(rels);
    }

    public void addComparableResources(Resource r1, Resource r2) {
        this.comparableResources.map((Object)r1, (Object)r2);
    }

    public void addComparableResources(BijectionMap<Resource, Resource> matching) {
        this.comparableResources.addAll(matching);
    }

    public void addStrong(Resource r) {
        this.strong.add(r);
    }

    public void addStrong(Collection<Resource> rels) {
        this.strong.addAll(rels);
    }

    public void addNonMatchedLeft(Resource r) {
        this.nonMatchedLeft.add(r);
    }

    public void addNonMatchedRight(Resource r) {
        this.nonMatchedRight.add(r);
    }

    public void test(ReadGraph g) throws DatabaseException {
        this.g = g;
        this.b = Layer0.getInstance((ReadGraph)g);
        this.comparator.setComparator(this);
        this.comparator.initialize(g, this.r1, this.r2);
        Stack<Resource> objectsLeft = new Stack<Resource>();
        Stack<Resource> objectsRight = new Stack<Resource>();
        objectsLeft.push(this.r1);
        objectsRight.push(this.r2);
        HashSet<Statement> unreliableLeft = new HashSet<Statement>();
        HashSet<Statement> unreliableRight = new HashSet<Statement>();
        while (!objectsLeft.isEmpty()) {
            this.process(objectsLeft, objectsRight, unreliableLeft, unreliableRight);
            this.processUnreliable(unreliableLeft, unreliableRight);
            this.processUnreliable(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
            if (objectsLeft.isEmpty() && unreliableLeft.size() > 0 && unreliableRight.size() > 0) {
                this.processUnreliable2(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
            }
            if (!objectsLeft.isEmpty() || unreliableLeft.size() <= 0 || unreliableRight.size() <= 0) continue;
            this.processUnreliableDeep(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
        }
        for (Statement s : unreliableLeft) {
            if (this.comparableStatements.containsLeft((Object)s)) continue;
            this.addDeletion(s);
        }
        for (Statement s : unreliableRight) {
            if (this.comparableStatements.containsRight((Object)s)) continue;
            this.addAddition(s);
        }
    }

    public void test(Session session) throws DatabaseException {
        this.test(session, this.r1, this.r2);
    }

    public void test(Session session, final Resource r1, final Resource r2) throws DatabaseException {
        this.comparator.setComparator(this);
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphComparator.this.comparator.initialize(graph, r1, r2);
            }
        });
        this.addComparable(r1, r2);
        final Stack<Resource> objectsLeft = new Stack<Resource>();
        final Stack<Resource> objectsRight = new Stack<Resource>();
        objectsLeft.push(r1);
        objectsRight.push(r2);
        final HashSet unreliableLeft = new HashSet();
        final HashSet unreliableRight = new HashSet();
        while (!objectsLeft.isEmpty()) {
            session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    GraphComparator.this.g = graph;
                    GraphComparator.this.b = Layer0.getInstance((ReadGraph)graph);
                    GraphComparator.this.process(objectsLeft, objectsRight, unreliableLeft, unreliableRight);
                    GraphComparator.this.processUnreliable(unreliableLeft, unreliableRight);
                    GraphComparator.this.processUnreliable(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
                    if (objectsLeft.isEmpty() && unreliableLeft.size() > 0 && unreliableRight.size() > 0) {
                        GraphComparator.this.processUnreliable2(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
                    }
                    if (objectsLeft.isEmpty() && unreliableLeft.size() > 0 && unreliableRight.size() > 0) {
                        GraphComparator.this.processUnreliableDeep(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
                    }
                    if (objectsLeft.isEmpty() && unreliableLeft.size() > 0 && unreliableRight.size() > 0) {
                        GraphComparator.this.processUnreliableDeep(unreliableLeft, unreliableRight, objectsLeft, objectsRight);
                    }
                }
            });
        }
        for (Statement s : unreliableLeft) {
            if (this.comparableStatements.containsLeft((Object)s)) continue;
            this.addDeletion(s);
        }
        for (Statement s : unreliableRight) {
            if (this.comparableStatements.containsRight((Object)s)) continue;
            this.addAddition(s);
        }
    }

    private void process(Stack<Resource> objectsLeft, Stack<Resource> objectsRight, Set<Statement> unreliableLeft, Set<Statement> unreliableRight) throws DatabaseException {
        List<Statement> ss1 = new ArrayList<Statement>();
        List<Statement> ss2 = new ArrayList<Statement>();
        while (!objectsLeft.isEmpty()) {
            Resource r2;
            Resource r1 = objectsLeft.pop();
            if (r1.equals(r2 = objectsRight.pop()) || this.processedResources.contains(r1)) continue;
            this.processedResources.add(r1);
            if ((this.comparableResources.containsLeft((Object)r1) || this.comparableResources.containsRight((Object)r2)) && !this.comparableResources.contains((Object)r1, (Object)r2)) {
                throw new DatabaseException("Comparator error: Trying to map " + r1 + " to " + r2 + " while mappings " + r1 + " to " + this.comparableResources.getRight((Object)r1) + " and " + this.comparableResources.getLeft((Object)r2) + " to " + r2 + " exist.");
            }
            this.addComparable(r1, r2);
            this.compareProps(r1, r2);
            for (Resource rel : this.tested) {
                ss1.addAll(this.g.getStatements(r1, rel));
                ss2.addAll(this.g.getStatements(r2, rel));
                ss1 = this.filterAsserted(r1, ss1);
                ss2 = this.filterAsserted(r2, ss2);
                ss1 = this.filterTraversed(ss1);
                ss2 = this.filterTraversed(ss2);
                ss1 = this.filterNonTested(ss1);
                ss2 = this.filterNonTested(ss2);
                this.compareStatements(ss1, ss2, null, null, null, null);
                ss1.clear();
                ss2.clear();
            }
            for (Resource rel : this.traversed) {
                ss1.addAll(this.g.getStatements(r1, rel));
                ss2.addAll(this.g.getStatements(r2, rel));
                ss1 = this.filterAsserted(r1, ss1);
                ss2 = this.filterAsserted(r2, ss2);
                ss1 = this.filterNonTraversed(ss1);
                ss2 = this.filterNonTraversed(ss2);
                this.compareStatements(ss1, ss2, objectsLeft, objectsRight, unreliableLeft, unreliableRight);
                ss1.clear();
                ss2.clear();
            }
        }
    }

    private void processUnreliable(Set<Statement> unreliableLeft, Set<Statement> unreliableRight) throws DatabaseException {
        MapList subjectLeft = new MapList();
        MapList subjectRight = new MapList();
        MapList objectLeft = new MapList();
        MapList objectRight = new MapList();
        for (Statement s : unreliableLeft) {
            subjectLeft.add((Object)s.getSubject(), (Object)s);
            objectLeft.add((Object)s.getObject(), (Object)s);
        }
        for (Statement s : unreliableRight) {
            subjectRight.add((Object)s.getSubject(), (Object)s);
            objectRight.add((Object)s.getObject(), (Object)s);
        }
        for (Resource left : subjectLeft.getKeys()) {
            Resource right = (Resource)this.comparableResources.getRight((Object)left);
            if (right == null) continue;
            for (Statement leftS : subjectLeft.getValues((Object)left)) {
                Resource rightO;
                Resource leftO = leftS.getObject();
                if (!unreliableLeft.contains(leftS) || (rightO = (Resource)this.comparableResources.getRight((Object)leftO)) == null) continue;
                for (Statement rightS : subjectRight.getValues((Object)right)) {
                    if (!rightS.getObject().equals(rightO) || !unreliableRight.contains(rightS) || !leftS.getPredicate().equals(rightS.getPredicate()) && !this.comparableResources.contains((Object)leftS.getPredicate(), (Object)rightS.getPredicate())) continue;
                    unreliableLeft.remove(leftS);
                    unreliableRight.remove(rightS);
                    this.addComparable(leftS, rightS);
                }
            }
        }
    }

    private void processUnreliable(Set<Statement> unreliableLeft, Set<Statement> unreliableRight, Stack<Resource> objectsLeft, Stack<Resource> objectsRight) throws DatabaseException {
        MapList subjectLeft = new MapList();
        MapList subjectRight = new MapList();
        MapList objectLeft = new MapList();
        MapList objectRight = new MapList();
        for (Statement s : unreliableLeft) {
            subjectLeft.add((Object)s.getSubject(), (Object)s);
            objectLeft.add((Object)s.getObject(), (Object)s);
        }
        for (Statement s : unreliableRight) {
            subjectRight.add((Object)s.getSubject(), (Object)s);
            objectRight.add((Object)s.getObject(), (Object)s);
        }
        for (Resource ol : objectLeft.getKeys()) {
            Object useSL;
            List left = objectLeft.getValues((Object)ol);
            HashSet<Resource> sLeft = new HashSet<Resource>();
            HashSet<Resource> sRight = new HashSet<Resource>();
            for (Statement s : left) {
                sLeft.add(s.getSubject());
                sRight.add((Resource)this.comparableResources.getRight((Object)s.getSubject()));
            }
            boolean hasSimilar = false;
            MapList comparableOLeft = new MapList();
            for (Resource sl : sLeft) {
                for (Statement s : subjectLeft.getValues((Object)sl)) {
                    if (s.getObject().equals(ol)) continue;
                    comparableOLeft.add((Object)s.getObject(), (Object)s);
                }
            }
            this.compareStatements(this.ss1, this.ss2, objectsLeft, objectsRight, unreliableLeft, unreliableRight);
            for (Resource similarOl : comparableOLeft.getKeys()) {
                List similarLeft = comparableOLeft.getValues((Object)similarOl);
                if (similarLeft.size() != left.size()) continue;
                boolean[] useL = new boolean[left.size()];
                useSL = new boolean[left.size()];
                int i = 0;
                while (i < left.size()) {
                    useL[i] = false;
                    useSL[i] = false;
                    ++i;
                }
                i = 0;
                while (i < left.size()) {
                    int j = 0;
                    while (j < left.size()) {
                        int comp;
                        Resource psl;
                        Resource pl;
                        if (useSL[j] == false && (pl = ((Statement)left.get(i)).getPredicate()).equals(psl = ((Statement)similarLeft.get(j)).getPredicate()) && (comp = this.comparator.compare(this.g, ((Statement)left.get(i)).getObject(), ((Statement)similarLeft.get(j)).getObject(), true)) >= 0 && comp < Integer.MAX_VALUE) {
                            useL[i] = true;
                            useSL[j] = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                boolean diff = false;
                int i2 = 0;
                while (i2 < left.size()) {
                    if (!useL[i2] || useSL[i2] == false) {
                        diff = true;
                    }
                    ++i2;
                }
                if (diff) continue;
                hasSimilar = true;
                break;
            }
            if (hasSimilar) continue;
            MapList possibleOR = new MapList();
            for (Resource sr : sRight) {
                useSL = subjectRight.getValues((Object)sr).iterator();
                while (useSL.hasNext()) {
                    Statement s = (Statement)useSL.next();
                    possibleOR.add((Object)s.getObject(), (Object)s);
                }
            }
            Resource[] resourceArray = possibleOR.getKeys().toArray(new Resource[possibleOR.getKeys().size()]);
            useSL = resourceArray;
            int s = resourceArray.length;
            int similarLeft = 0;
            while (similarLeft < s) {
                Object or = useSL[similarLeft];
                List right = possibleOR.getValues(or);
                if (right.size() != left.size()) {
                    possibleOR.remove(or);
                }
                ++similarLeft;
            }
            MapList matchingOR = new MapList();
            HashMap<Resource, Pair> matchingStatements = new HashMap<Resource, Pair>();
            for (Resource or : possibleOR.getKeys()) {
                List right = possibleOR.getValues((Object)or);
                int[] iLeft = new int[left.size()];
                int[] iRight = new int[right.size()];
                int i = 0;
                while (i < left.size()) {
                    iLeft[i] = -1;
                    iRight[i] = -1;
                    ++i;
                }
                int l = 0;
                while (l < left.size()) {
                    Statement ls = (Statement)left.get(l);
                    int r = 0;
                    while (r < right.size()) {
                        if (iRight[r] < 0) {
                            Statement rs = (Statement)right.get(r);
                            if (this.comparableResources.contains((Object)ls.getSubject(), (Object)rs.getSubject()) && this.rcomp.compare(ls.getPredicate(), rs.getPredicate()) == 0) {
                                int comp = this.comparator.compare(this.g, ls.getObject(), rs.getObject());
                                if (comp <= 0 || comp >= Integer.MAX_VALUE) break;
                                iLeft[l] = r;
                                iRight[r] = l;
                                break;
                            }
                        }
                        ++r;
                    }
                    ++l;
                }
                boolean success = true;
                int i3 = 0;
                while (i3 < left.size()) {
                    if (iLeft[i3] < 0) {
                        success = false;
                        break;
                    }
                    if (iRight[i3] < 0) {
                        success = false;
                        break;
                    }
                    ++i3;
                }
                if (!success) continue;
                for (Statement s2 : right) {
                    matchingOR.add((Object)or, (Object)s2);
                }
                matchingStatements.put(or, new Pair((Object)iLeft, (Object)iRight));
            }
            if (matchingOR.getKeySize() != 1) continue;
            Resource or = (Resource)matchingOR.getKeys().iterator().next();
            List right = matchingOR.getValues((Object)or);
            Pair indices = (Pair)matchingStatements.get(or);
            objectsLeft.add(ol);
            objectsRight.add(or);
            this.addComparable(ol, or);
            int l = 0;
            while (l < left.size()) {
                int r = ((int[])indices.first)[l];
                Statement sl = (Statement)left.get(l);
                Statement sr = (Statement)right.get(r);
                this.addComparable(sl, sr);
                unreliableLeft.remove(sl);
                unreliableRight.remove(sr);
                ++l;
            }
        }
    }

    private void processUnreliable2(Set<Statement> unreliableLeft, Set<Statement> unreliableRight, Stack<Resource> objectsLeft, Stack<Resource> objectsRight) throws DatabaseException {
        MapList subjectLeft = new MapList();
        MapList subjectRight = new MapList();
        MapList objectLeft = new MapList();
        MapList objectRight = new MapList();
        for (Statement s : unreliableLeft) {
            subjectLeft.add((Object)s.getSubject(), (Object)s);
            objectLeft.add((Object)s.getObject(), (Object)s);
        }
        for (Statement s : unreliableRight) {
            subjectRight.add((Object)s.getSubject(), (Object)s);
            objectRight.add((Object)s.getObject(), (Object)s);
        }
        for (Resource ol : objectLeft.getKeys()) {
            List left = objectLeft.getValues((Object)ol);
            HashSet<Resource> sLeft = new HashSet<Resource>();
            HashSet<Resource> sRight = new HashSet<Resource>();
            for (Statement s : left) {
                sLeft.add(s.getSubject());
                sRight.add((Resource)this.comparableResources.getRight((Object)s.getSubject()));
            }
            if (sLeft.size() != 1 || sRight.size() != 1) continue;
            ArrayList<Statement> ss1 = new ArrayList<Statement>(subjectLeft.getValues((Object)((Resource)sLeft.iterator().next())));
            ArrayList<Statement> ss2 = new ArrayList<Statement>(subjectRight.getValues((Object)((Resource)sRight.iterator().next())));
            int count = this.comparableStatements.size();
            this.compareStatements(ss1, ss2, objectsLeft, objectsRight, unreliableLeft, unreliableRight);
            if (this.comparableStatements.size() <= count) continue;
            for (Map.Entry entry : this.comparableStatements.getEntries()) {
                unreliableLeft.remove(entry.getKey());
                unreliableRight.remove(entry.getValue());
            }
        }
    }

    private void processUnreliableDeep(Set<Statement> unreliableLeft, Set<Statement> unreliableRight, Stack<Resource> objectsLeft, Stack<Resource> objectsRight) throws DatabaseException {
        MapList subjectLeft = new MapList();
        MapList subjectRight = new MapList();
        MapList objectLeft = new MapList();
        MapList objectRight = new MapList();
        for (Statement s : unreliableLeft) {
            subjectLeft.add((Object)s.getSubject(), (Object)s);
            objectLeft.add((Object)s.getObject(), (Object)s);
        }
        for (Statement s : unreliableRight) {
            subjectRight.add((Object)s.getSubject(), (Object)s);
            objectRight.add((Object)s.getObject(), (Object)s);
        }
        for (Resource ol : objectLeft.getKeys()) {
            Resource or2;
            HashSet<Path> pathsLeft;
            block11: {
                ArrayList<Path> endPaths;
                pathsLeft = new HashSet<Path>();
                for (Resource rel : this.traversed) {
                    pathsLeft.addAll(Path.create(this.g.getStatements(ol, rel)));
                }
                do {
                    this.expand(pathsLeft);
                    if (pathsLeft.size() == 0) break block11;
                    endPaths = new ArrayList<Path>(1);
                    for (Path p : pathsLeft) {
                        if (!this.comparableResources.containsLeft((Object)p.getEnd())) continue;
                        endPaths.add(p);
                    }
                } while (endPaths.size() <= 0);
                pathsLeft.clear();
                pathsLeft.addAll(endPaths);
            }
            if (pathsLeft.size() <= 0) continue;
            Resource sl = ((Statement)objectLeft.getValues((Object)ol).get(0)).getSubject();
            Resource sr = (Resource)this.comparableResources.getRight((Object)sl);
            ArrayList<Resource> possibleOR = new ArrayList<Resource>();
            for (Statement s : subjectRight.getValues((Object)sr)) {
                possibleOR.add(s.getObject());
            }
            HashMap<Resource, HashSet<Path>> matchingPaths = new HashMap<Resource, HashSet<Path>>();
            for (Resource or2 : possibleOR) {
                HashSet<Path> possiblePathsRight = new HashSet<Path>();
                for (Path leftPath : pathsLeft) {
                    possiblePathsRight.addAll(this.findComparableRight(leftPath, or2));
                }
                if (!this.hasMatchingPaths(pathsLeft, possiblePathsRight)) continue;
                matchingPaths.put(or2, possiblePathsRight);
            }
            if (matchingPaths.size() <= 0 || matchingPaths.size() != 1) continue;
            or2 = (Resource)matchingPaths.keySet().iterator().next();
            objectsLeft.add(ol);
            objectsRight.add(or2);
            this.addComparable(ol, or2);
            List statementsLeft = objectLeft.getValues((Object)ol);
            List statementsRight = objectRight.getValues((Object)or2);
            unreliableLeft.removeAll(statementsLeft);
            unreliableRight.removeAll(statementsRight);
            BijectionMap<Path, Path> map = this.getMatchingPaths(pathsLeft, (Set)matchingPaths.get(or2));
            for (Path left : map.getLeftSet()) {
                Path right = (Path)map.getRight((Object)left);
                int i = 0;
                while (i < left.getLength()) {
                    this.addComparable(left.getStatements().get(i), right.getStatements().get(i));
                    ++i;
                }
            }
        }
    }

    private boolean hasMatchingPaths(Set<Path> leftPaths, Set<Path> rightPaths) {
        if (leftPaths.size() != rightPaths.size()) {
            return false;
        }
        BijectionMap<Path, Path> map = this.getMatchingPaths(leftPaths, rightPaths);
        return map.size() == leftPaths.size();
    }

    private BijectionMap<Path, Path> getMatchingPaths(Set<Path> leftPaths, Set<Path> rightPaths) {
        BijectionMap map = new BijectionMap();
        block0: for (Path leftPath : leftPaths) {
            for (Path rightPath : rightPaths) {
                if (map.containsRight((Object)rightPath) || leftPath.getLength() != rightPath.getLength() || !this.comparableResources.contains((Object)leftPath.getEnd(), (Object)rightPath.getEnd())) continue;
                boolean match = true;
                int i = 0;
                while (i < leftPath.getLength()) {
                    Statement sl = leftPath.getStatements().get(i);
                    Statement sr = rightPath.getStatements().get(i);
                    if (!sl.getPredicate().equals(sr.getPredicate()) && !this.comparableResources.contains((Object)sl.getPredicate(), (Object)sr.getPredicate())) {
                        match = false;
                        break;
                    }
                    if ((this.getComparableResources().containsLeft((Object)sl.getObject()) || this.getComparableResources().containsRight((Object)sr.getObject())) && !this.getComparableResources().contains((Object)sl.getObject(), (Object)sr.getObject())) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                map.map((Object)leftPath, (Object)rightPath);
                continue block0;
            }
        }
        return map;
    }

    private void expand(Set<Path> paths) throws DatabaseException {
        HashSet<Path> stepPathsLeft = new HashSet<Path>();
        if (paths.size() == 0) {
            return;
        }
        int length = paths.iterator().next().getLength() + 1;
        for (Path p : paths) {
            for (Resource rel : this.traversed) {
                stepPathsLeft.addAll(Path.expand(p, this.g.getStatements(p.getEnd(), rel)));
            }
        }
        paths.clear();
        for (Path p : stepPathsLeft) {
            if (p.getLength() != length) continue;
            paths.add(p);
        }
    }

    private Collection<Path> findComparableRight(Path leftPath, Resource beginRight) throws DatabaseException {
        HashSet<Path> rightPaths = new HashSet<Path>();
        rightPaths.addAll(Path.create(this.g.getStatements(beginRight, this.getRight(leftPath.getStatements().get(0).getPredicate()))));
        int i = 1;
        while (i < leftPath.getLength()) {
            if (rightPaths.size() == 0) {
                return rightPaths;
            }
            HashSet<Path> stepPaths = new HashSet<Path>();
            for (Path p : rightPaths) {
                stepPaths.addAll(Path.expand(p, this.g.getStatements(p.getEnd(), this.getRight(leftPath.getStatements().get(i).getPredicate()))));
            }
            rightPaths.clear();
            for (Path p : stepPaths) {
                if (p.getLength() != i + 1) continue;
                rightPaths.add(p);
            }
            ++i;
        }
        return rightPaths;
    }

    private Resource getRight(Resource r) {
        if (this.comparableResources.containsLeft((Object)r)) {
            return (Resource)this.comparableResources.getRight((Object)r);
        }
        return r;
    }

    public BijectionMap<Statement, Statement> getComparableStatements() {
        return this.comparableStatements;
    }

    public BijectionMap<Resource, Resource> getComparableResources() {
        return this.comparableResources;
    }

    public GraphChanges getChanges() {
        return new GraphChanges(this.r1, this.r2, this.changes1, this.changes2, this.modifications, this.comparableResources);
    }

    private void addComparable(Statement left, Statement right) throws DatabaseException {
        this.addComparable(left.getObject(), right.getObject());
        this.comparableStatements.map((Object)left, (Object)right);
    }

    private void addComparable(Resource left, Resource right) throws DatabaseException {
        if (!this.comparableResources.contains((Object)left, (Object)right)) {
            if (this.comparableResources.containsLeft((Object)left) || this.comparableResources.containsRight((Object)right)) {
                throw new DatabaseException("Comparator error: Trying to map " + left + " to " + right + " while mappings " + left + " to " + this.comparableResources.getRight((Object)left) + " and " + this.comparableResources.getLeft((Object)right) + " to " + right + " exist.");
            }
            this.comparableResources.map((Object)left, (Object)right);
        }
    }

    public List<Statement> filterAsserted(Resource r, Collection<Statement> in) throws DatabaseException {
        ArrayList<Statement> out = new ArrayList<Statement>();
        for (Statement s : in) {
            if (s.isAsserted(r)) continue;
            out.add(s);
        }
        return out;
    }

    public List<Statement> filterAssertedDuplicates(Resource r, List<Statement> in) throws DatabaseException {
        ArrayList<Statement> out = new ArrayList<Statement>();
        int i = 0;
        while (i < in.size()) {
            Statement s = in.get(i);
            if (!s.isAsserted(r)) {
                out.add(s);
            } else {
                boolean has = false;
                if (i > 1 && in.get(i - 1).getPredicate().equals(s.getPredicate())) {
                    has = true;
                } else if (i < in.size() - 1 && in.get(i + 1).getPredicate().equals(s.getPredicate())) {
                    has = true;
                }
                if (!has) {
                    out.add(s);
                }
            }
            ++i;
        }
        for (Statement s : in) {
            if (s.isAsserted(r)) continue;
            out.add(s);
        }
        return out;
    }

    private String printStatement(ReadGraph graph, Statement s) throws DatabaseException {
        return String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getObject());
    }

    private List<Statement> filterTraversed(List<Statement> in) throws DatabaseException {
        return this.filter(this.traversed, in);
    }

    private List<Statement> filterNonTested(List<Statement> in) throws DatabaseException {
        return this.filter(this.nonTested, in);
    }

    private List<Statement> filterNonTraversed(List<Statement> in) throws DatabaseException {
        return this.filter(this.nonTraversed, in);
    }

    private List<Statement> filter(Collection<Resource> toFilter, List<Statement> in) throws DatabaseException {
        if (toFilter.size() == 0) {
            return in;
        }
        ArrayList<Statement> out = new ArrayList<Statement>();
        for (Statement s : in) {
            boolean usable = true;
            for (Resource r : toFilter) {
                if (!this.g.isSubrelationOf(s.getPredicate(), r)) continue;
                usable = false;
                break;
            }
            if (!usable) continue;
            out.add(s);
        }
        return out;
    }

    private void addDeletion(Statement s) {
        if (!this.changes1Set.contains(s)) {
            this.changes1Set.add(s);
            this.changes1.add(s);
        }
    }

    private void addAddition(Statement s) {
        if (!this.changes2Set.contains(s)) {
            this.changes2Set.add(s);
            this.changes2.add(s);
        }
    }

    private void addModification(Resource sub1, Statement s1, Resource sub2, Statement s2) {
        GraphChanges.Modification mod = new GraphChanges.Modification(sub1, sub2, s1, s2);
        if (!this.modificationsSet.contains(mod)) {
            this.modificationsSet.add(mod);
            this.modifications.add(mod);
        }
    }

    public void sortStatement(List<Statement> list1, List<Statement> list2) {
        this.sortStatement(list1, list2, this.scomp);
    }

    public void sortStatement(List<Statement> list1, List<Statement> list2, Comparator<Statement> scomp) {
        Collections.sort(list1, scomp);
        Collections.sort(list2, scomp);
        ArrayList<Statement> sorted1 = new ArrayList<Statement>(list1.size());
        ArrayList<Statement> sorted2 = new ArrayList<Statement>(list2.size());
        sorted1.addAll(list1);
        sorted2.addAll(list2);
        int ss1 = 0;
        int ss2 = 0;
        int i = 0;
        while (i < list1.size()) {
            Statement s1 = list1.get(i);
            int same1 = this.sameRel(list1, i);
            int j = 0;
            while (j < list2.size()) {
                Statement s2 = list2.get(j);
                if (scomp.compare(s1, s2) == 0) {
                    int same2 = this.sameRel(list2, j);
                    this.copy(sorted1, ss1, list1, i, same1);
                    ss1 += same1;
                    this.copy(sorted2, ss2, list2, j, same2);
                    ss2 += same2;
                    break;
                }
                ++j;
            }
            i += same1;
        }
        if (ss1 < sorted1.size()) {
            for (Statement s : list1) {
                if (sorted1.contains(s)) continue;
                sorted1.set(ss1, s);
                ++ss1;
            }
        }
        if (ss2 < sorted2.size()) {
            for (Statement s : list2) {
                if (sorted2.contains(s)) continue;
                sorted2.set(ss2, s);
                ++ss2;
            }
        }
        list1.clear();
        list2.clear();
        list1.addAll(sorted1);
        list2.addAll(sorted2);
    }

    public <T> void copy(List<T> to, int toIndex, List<T> from, int fromIndex, int amount) {
        int i = 0;
        while (i < amount) {
            to.set(toIndex + i, from.get(fromIndex + i));
            ++i;
        }
    }

    public void sortResource(List<Resource> list1, List<Resource> list2) {
        Collections.sort(list1, this.rcomp);
        int js = 0;
        int i = 0;
        while (i < list1.size()) {
            Resource s1 = list1.get(i);
            int j = js;
            while (j < list2.size()) {
                Resource s2 = list2.get(j);
                if (this.rcomp.compare(s1, s2) == 0) {
                    Resource t = list2.get(js);
                    list2.set(js, s2);
                    list2.set(j, t);
                    break;
                }
                ++j;
            }
            ++js;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compareStatements(List<Statement> ss1, List<Statement> ss2, Stack<Resource> objectsLeft, Stack<Resource> objectsRight, Collection<Statement> unreliableLeft, Collection<Statement> unreliableRight) throws DatabaseException {
        this.sortStatement(ss1, ss2);
        i1 = 0;
        i2 = 0;
        while (true) {
            block8: {
                if (i1 < ss1.size()) break block8;
                if (i2 < ss2.size()) ** GOTO lbl10
                break;
lbl-1000:
                // 1 sources

                {
                    this.addAddition(ss2.get(i2));
                    ++i2;
lbl10:
                    // 2 sources

                    ** while (i2 < ss2.size())
                }
lbl11:
                // 1 sources

                break;
            }
            if (i2 >= ss2.size()) {
                while (i1 < ss1.size()) {
                    this.addDeletion(ss1.get(i1));
                    ++i1;
                }
                break;
            }
            same1 = this.sameRel(ss1, i1);
            same2 = this.sameRel(ss2, i2);
            c = this.rcomp.compare(ss1.get(i1).getPredicate(), ss2.get(i2).getPredicate());
            if (c == 0) {
                this.compareStatements(ss1, i1, same1, ss2, i2, same2, objectsLeft, objectsRight, unreliableLeft, unreliableRight);
                i1 += same1;
                i2 += same2;
                continue;
            }
            if (c < 0) {
                i = 0;
                while (i < same1) {
                    this.addDeletion(ss1.get(i + i1));
                    ++i;
                }
                i1 += same1;
                continue;
            }
            i = 0;
            while (i < same2) {
                this.addAddition(ss2.get(i + i2));
                ++i;
            }
            i2 += same2;
        }
    }

    private int sameRel(List<Statement> statements, int off) {
        if (statements.size() <= off) {
            return 0;
        }
        int same = 1;
        long id = statements.get(off).getPredicate().getResourceId();
        int i = off + 1;
        while (i < statements.size()) {
            if (statements.get(i).getPredicate().getResourceId() != id) break;
            ++same;
            ++i;
        }
        return same;
    }

    private int compareObject(Resource o1, Resource o2) throws DatabaseException {
        if (o1.equals(o2)) {
            return -1;
        }
        if (this.comparableResources.contains((Object)o1, (Object)o2)) {
            return -1;
        }
        if (this.comparableResources.containsLeft((Object)o1)) {
            return Integer.MAX_VALUE;
        }
        if (this.comparableResources.containsRight((Object)o2)) {
            return Integer.MAX_VALUE;
        }
        if (this.nonMatchedLeft.contains(o1)) {
            return Integer.MAX_VALUE;
        }
        if (this.nonMatchedRight.contains(o2)) {
            return Integer.MAX_VALUE;
        }
        return this.comparator.compare(this.g, o1, o2);
    }

    private void compareStatements(List<Statement> ss1, int off1, int len1, List<Statement> ss2, int off2, int len2, Collection<Resource> objectsLeft, Collection<Resource> objectsRight, Collection<Statement> unreliableLeft, Collection<Statement> unreliableRight) throws DatabaseException {
        Object pri;
        boolean[] used1 = new boolean[len1];
        int i = 0;
        while (i < used1.length) {
            used1[i] = false;
            ++i;
        }
        boolean[] used2 = new boolean[len2];
        int i2 = 0;
        while (i2 < used2.length) {
            used2[i2] = false;
            ++i2;
        }
        ArrayList differences = new ArrayList();
        int i1 = off1;
        while (i1 < off1 + len1) {
            Statement s1 = ss1.get(i1);
            ArrayList<Integer> diff = new ArrayList<Integer>();
            int i22 = off2;
            while (i22 < off2 + len2) {
                Statement s2 = ss2.get(i22);
                int d = this.compareObject(s1.getObject(), s2.getObject());
                if (d == 0) {
                    for (Resource t : this.strong) {
                        if (!s1.getPredicate().equals(t) && !this.g.isSubrelationOf(s1.getPredicate(), t)) continue;
                        d = 1;
                        break;
                    }
                }
                diff.add(d);
                ++i22;
            }
            differences.add(diff);
            ++i1;
        }
        MapList priorities = new MapList();
        int i3 = 0;
        while (i3 < differences.size()) {
            List list = (List)differences.get(i3);
            int j = 0;
            while (j < list.size()) {
                priorities.add((Object)((Integer)list.get(j)), (Object)i3);
                ++j;
            }
            ++i3;
        }
        Object[] pris = (Integer[])priorities.getKeys((Object[])new Integer[0]);
        Arrays.sort(pris);
        Object[] objectArray = pris;
        int n = pris.length;
        int n2 = 0;
        while (n2 < n) {
            pri = objectArray[n2];
            if ((Integer)pri != Integer.MAX_VALUE && (Integer)pri != 0) {
                List i1s = priorities.getValues(pri);
                block8: for (Integer i12 : i1s) {
                    if (used1[i12]) continue;
                    List i2diff = (List)differences.get(i12);
                    int i23 = 0;
                    while (i23 < i2diff.size()) {
                        if (i2diff.get(i23) == pri && !used2[i23]) {
                            used1[i12.intValue()] = true;
                            used2[i23] = true;
                            Statement s1 = ss1.get(i12 + off1);
                            Statement s2 = ss2.get(i23 + off2);
                            if (objectsLeft != null) {
                                objectsLeft.add(s1.getObject());
                                objectsRight.add(s2.getObject());
                            }
                            this.addComparable(s1, s2);
                            continue block8;
                        }
                        ++i23;
                    }
                }
            }
            ++n2;
        }
        objectArray = pris;
        n = pris.length;
        n2 = 0;
        while (n2 < n) {
            pri = objectArray[n2];
            if ((Integer)pri == 0) {
                HashSet<Statement> s1s = new HashSet<Statement>();
                HashSet<Statement> s2s = new HashSet<Statement>();
                HashSet<Integer> s1i = new HashSet<Integer>();
                HashSet<Integer> s2i = new HashSet<Integer>();
                List i1s = priorities.getValues(pri);
                for (Integer i13 : i1s) {
                    if (used1[i13]) continue;
                    List i2diff = (List)differences.get(i13);
                    int i24 = 0;
                    while (i24 < i2diff.size()) {
                        if (i2diff.get(i24) == pri && !used2[i24]) {
                            Statement s1 = ss1.get(i13 + off1);
                            Statement s2 = ss2.get(i24 + off2);
                            s1s.add(s1);
                            s2s.add(s2);
                            s1i.add(i13);
                            s2i.add(i24);
                        }
                        ++i24;
                    }
                }
                if (unreliableLeft != null) {
                    unreliableLeft.addAll(s1s);
                    unreliableRight.addAll(s2s);
                }
                for (Integer i4 : s1i) {
                    used1[i4.intValue()] = true;
                }
                for (Integer i4 : s2i) {
                    used2[i4.intValue()] = true;
                }
            }
            ++n2;
        }
        int i14 = off1;
        while (i14 < off1 + len1) {
            if (!used1[i14 - off1]) {
                this.addDeletion(ss1.get(i14));
            }
            ++i14;
        }
        int i25 = off2;
        while (i25 < off2 + len2) {
            if (!used2[i25 - off2]) {
                this.addAddition(ss2.get(i25));
            }
            ++i25;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compareProps(Resource r1, Resource r2) throws DatabaseException {
        ss1 = new ArrayList<Statement>();
        ss2 = new ArrayList<Statement>();
        ss1.addAll(this.g.getStatements(r1, this.b.HasProperty));
        ss2.addAll(this.g.getStatements(r2, this.b.HasProperty));
        ss1 = this.filterNonTested(ss1);
        ss2 = this.filterNonTested(ss2);
        this.sortStatement(ss1, ss2);
        ss1 = this.filterAssertedDuplicates(r1, ss1);
        ss2 = this.filterAssertedDuplicates(r2, ss2);
        i1 = 0;
        i2 = 0;
        while (true) {
            block20: {
                if (i1 < ss1.size()) break block20;
                if (i2 < ss2.size()) ** GOTO lbl22
                break;
lbl-1000:
                // 1 sources

                {
                    s = ss2.get(i2);
                    if (!s.isAsserted(r2)) {
                        this.addAddition(s);
                    }
                    ++i2;
lbl22:
                    // 2 sources

                    ** while (i2 < ss2.size())
                }
lbl23:
                // 1 sources

                break;
            }
            if (i2 >= ss2.size()) {
                while (i1 < ss1.size()) {
                    s = ss1.get(i1);
                    if (!s.isAsserted(r1)) {
                        this.addDeletion(s);
                    }
                    ++i1;
                }
                break;
            }
            s1 = ss1.get(i1);
            s2 = ss2.get(i2);
            if (s1.isAsserted(r1) && s2.isAsserted(r2)) {
                ++i1;
                ++i2;
                continue;
            }
            c = this.scomp.compare(s1, s2);
            switch (c) {
                case 0: {
                    b1 = this.g.hasValue(s1.getObject());
                    b2 = this.g.hasValue(s2.getObject());
                    if (b1 == b2) {
                        if (b1) {
                            eq = GraphComparator.compareValue(this.g, this.b, s1.getObject(), s2.getObject());
                            if (!eq) {
                                this.addModification(r1, s1, r2, s2);
                                if (!s1.isAsserted(r1) && !s2.isAsserted(r2)) {
                                    this.addComparable(s1, s2);
                                }
                            }
                        } else if (!s1.getObject().equals(s1.getSubject()) && !s2.getObject().equals(s2.getSubject())) {
                            this.compareProps(s1.getObject(), s2.getObject());
                        }
                    } else {
                        this.addModification(r1, s1, r2, s2);
                        if (!s1.isAsserted(r1) && !s2.isAsserted(r2)) {
                            this.addComparable(s1, s2);
                        }
                    }
                    ++i1;
                    ++i2;
                    break;
                }
                case -1: {
                    this.addDeletion(s1);
                    ++i1;
                    break;
                }
                case 1: {
                    this.addAddition(s2);
                    ++i2;
                }
            }
        }
        ss1.clear();
        ss2.clear();
    }

    public static boolean compareValue(ReadGraph g, Layer0 b, Resource r1, Resource r2) throws DatabaseException {
        Resource t2;
        Resource t1 = g.getSingleType(r1);
        if (!t1.equals(t2 = g.getSingleType(r2))) {
            return false;
        }
        if (t1.equals(b.Integer)) {
            int v2;
            int v1 = (Integer)g.getValue(r1, (Binding)Bindings.INTEGER);
            return v1 == (v2 = ((Integer)g.getValue(r2, (Binding)Bindings.INTEGER)).intValue());
        }
        if (t1.equals(b.Float)) {
            float v2;
            float v1 = ((Float)g.getValue(r1, (Binding)Bindings.FLOAT)).floatValue();
            return v1 == (v2 = ((Float)g.getValue(r2, (Binding)Bindings.FLOAT)).floatValue());
        }
        if (t1.equals(b.Double)) {
            double v2;
            double v1 = (Double)g.getValue(r1, (Binding)Bindings.DOUBLE);
            return v1 == (v2 = ((Double)g.getValue(r2, (Binding)Bindings.DOUBLE)).doubleValue());
        }
        if (t1.equals(b.String)) {
            String v1 = (String)g.getValue(r1, (Binding)Bindings.STRING);
            String v2 = (String)g.getValue(r2, (Binding)Bindings.STRING);
            return v1.equals(v2);
        }
        if (t1.equals(b.Boolean)) {
            boolean v2;
            boolean v1 = (Boolean)g.getValue(r1, (Binding)Bindings.BOOLEAN);
            return v1 == (v2 = ((Boolean)g.getValue(r2, (Binding)Bindings.BOOLEAN)).booleanValue());
        }
        if (t1.equals(b.Byte)) {
            byte v2;
            byte v1 = (Byte)g.getValue(r1, (Binding)Bindings.BYTE);
            return v1 == (v2 = ((Byte)g.getValue(r2, (Binding)Bindings.BYTE)).byteValue());
        }
        if (t1.equals(b.Long)) {
            long v2;
            long v1 = (Long)g.getValue(r1, (Binding)Bindings.LONG);
            return v1 == (v2 = ((Long)g.getValue(r2, (Binding)Bindings.LONG)).longValue());
        }
        if (t1.equals(b.IntegerArray)) {
            int[] v1 = (int[])g.getValue(r1, (Binding)Bindings.INT_ARRAY);
            int[] v2 = (int[])g.getValue(r2, (Binding)Bindings.INT_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.FloatArray)) {
            float[] v1 = (float[])g.getValue(r1, (Binding)Bindings.FLOAT_ARRAY);
            float[] v2 = (float[])g.getValue(r2, (Binding)Bindings.FLOAT_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.DoubleArray)) {
            double[] v1 = (double[])g.getValue(r1, (Binding)Bindings.DOUBLE_ARRAY);
            double[] v2 = (double[])g.getValue(r2, (Binding)Bindings.DOUBLE_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.StringArray)) {
            Object[] v1 = (String[])g.getValue(r1, (Binding)Bindings.STRING_ARRAY);
            Object[] v2 = (String[])g.getValue(r2, (Binding)Bindings.STRING_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.BooleanArray)) {
            boolean[] v1 = (boolean[])g.getValue(r1, (Binding)Bindings.BOOLEAN_ARRAY);
            boolean[] v2 = (boolean[])g.getValue(r2, (Binding)Bindings.BOOLEAN_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.ByteArray)) {
            byte[] v1 = (byte[])g.getValue(r1, (Binding)Bindings.BYTE_ARRAY);
            byte[] v2 = (byte[])g.getValue(r2, (Binding)Bindings.BYTE_ARRAY);
            return Arrays.equals(v1, v2);
        }
        if (t1.equals(b.LongArray)) {
            long[] v1 = (long[])g.getValue(r1, (Binding)Bindings.LONG_ARRAY);
            long[] v2 = (long[])g.getValue(r2, (Binding)Bindings.LONG_ARRAY);
            return Arrays.equals(v1, v2);
        }
        Object v1 = g.getValue(r1);
        Object v2 = g.getValue(r2);
        return GraphComparator.compareValue(v1, v2);
    }

    public static boolean compareValue(Object v1, Object v2) {
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])v1, (Object[])v2);
        }
        if (v1 instanceof int[] && v2 instanceof int[]) {
            return Arrays.equals((int[])v1, (int[])v2);
        }
        if (v1 instanceof float[] && v2 instanceof float[]) {
            return Arrays.equals((float[])v1, (float[])v2);
        }
        if (v1 instanceof double[] && v2 instanceof double[]) {
            return Arrays.equals((double[])v1, (double[])v2);
        }
        if (v1 instanceof long[] && v2 instanceof long[]) {
            return Arrays.equals((long[])v1, (long[])v2);
        }
        if (v1 instanceof byte[] && v2 instanceof byte[]) {
            return Arrays.equals((byte[])v1, (byte[])v2);
        }
        if (v1 instanceof boolean[] && v2 instanceof boolean[]) {
            return Arrays.equals((boolean[])v1, (boolean[])v2);
        }
        return v1.equals(v2);
    }

    public static class FullStatementComparator
    implements Comparator<Statement> {
        @Override
        public int compare(Statement o1, Statement o2) {
            if (o1.getSubject().getResourceId() < o2.getSubject().getResourceId()) {
                return -1;
            }
            if (o1.getSubject().getResourceId() > o2.getSubject().getResourceId()) {
                return 1;
            }
            if (o1.getPredicate().getResourceId() < o2.getPredicate().getResourceId()) {
                return -1;
            }
            if (o1.getPredicate().getResourceId() > o2.getPredicate().getResourceId()) {
                return 1;
            }
            if (o1.getObject().getResourceId() < o2.getObject().getResourceId()) {
                return -1;
            }
            if (o1.getObject().getResourceId() > o2.getObject().getResourceId()) {
                return 1;
            }
            return 0;
        }
    }

    public class ObjectComparator
    implements Comparator<Statement> {
        @Override
        public int compare(Statement o1, Statement o2) {
            if (GraphComparator.this.comparableResources.contains((Object)o1.getObject(), (Object)o2.getObject())) {
                return 0;
            }
            if (o1.getObject().getResourceId() < o2.getObject().getResourceId()) {
                return -1;
            }
            if (o1.getObject().getResourceId() > o2.getObject().getResourceId()) {
                return 1;
            }
            return 0;
        }
    }

    public class PredicateComparator
    implements Comparator<Statement> {
        @Override
        public int compare(Statement o1, Statement o2) {
            if (GraphComparator.this.comparableResources.contains((Object)o1.getPredicate(), (Object)o2.getPredicate())) {
                return 0;
            }
            if (o1.getPredicate().getResourceId() < o2.getPredicate().getResourceId()) {
                return -1;
            }
            if (o1.getPredicate().getResourceId() > o2.getPredicate().getResourceId()) {
                return 1;
            }
            return 0;
        }
    }

    public class ResComparator
    implements Comparator<Resource> {
        @Override
        public int compare(Resource o1, Resource o2) {
            if (GraphComparator.this.comparableResources.contains((Object)o1, (Object)o2)) {
                return 0;
            }
            if (o1.getResourceId() < o2.getResourceId()) {
                return -1;
            }
            if (o1.getResourceId() > o2.getResourceId()) {
                return 1;
            }
            return 0;
        }
    }

    public class SubjectComparator
    implements Comparator<Statement> {
        @Override
        public int compare(Statement o1, Statement o2) {
            if (GraphComparator.this.comparableResources.contains((Object)o1.getSubject(), (Object)o2.getSubject())) {
                return 0;
            }
            if (o1.getSubject().getResourceId() < o2.getSubject().getResourceId()) {
                return -1;
            }
            if (o1.getSubject().getResourceId() > o2.getSubject().getResourceId()) {
                return 1;
            }
            return 0;
        }
    }
}

