/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ObjectIdentifiable;

public class ObjectSetIdentifiable
implements Identifiable {
    private Set<Object> objs = new HashSet<Object>();

    public ObjectSetIdentifiable(Object obj) {
        this.objs.add(obj);
    }

    public ObjectSetIdentifiable(Object ... obj) {
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object r = objectArray[n2];
            this.objs.add(r);
            ++n2;
        }
    }

    public ObjectSetIdentifiable(Collection<Object> obj) {
        for (Object r : obj) {
            this.objs.add(r);
        }
    }

    public Set<Object> getObjects() {
        return this.objs;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.equals(String.class)) {
            String s = "";
            for (Object o : this.objs) {
                s = String.valueOf(s) + o.toString() + " ";
            }
            return (T)s;
        }
        return null;
    }

    public int hashCode() {
        return this.objs.hashCode();
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ObjectSetIdentifiable other = (ObjectSetIdentifiable)arg0;
        return this.objs.equals(other.objs);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        if (other instanceof ObjectIdentifiable) {
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.addAll(this.objs);
            coll.add(((ObjectIdentifiable)other).getObject());
            ObjectSetIdentifiable i = new ObjectSetIdentifiable(coll);
            return i;
        }
        if (other instanceof ObjectSetIdentifiable) {
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.addAll(this.objs);
            coll.addAll(((ObjectSetIdentifiable)other).getObjects());
            ObjectSetIdentifiable i = new ObjectSetIdentifiable(coll);
            return i;
        }
        return null;
    }
}

