/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.diagram;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.interop.diagram.Diagram;
import org.simantics.interop.diagram.DiagramUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

public abstract class Symbol {
    private static boolean USE_UNRELIABLE_CONNECT = false;
    private static boolean PREVENT_SELF_CONNECTIONS = false;
    private Diagram diagram;
    Resource element;
    Resource component;

    public Symbol(Diagram diagram, Resource element, Resource component) {
        assert (diagram != null);
        assert (element != null);
        this.diagram = diagram;
        this.element = element;
        this.component = component;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Resource getComponent() {
        return this.component;
    }

    public Resource getElement() {
        return this.element;
    }

    public SymbolConnectionData connect(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2) throws DatabaseException {
        return this.connect(g, symbolConf2, componentConRel1, componentConRel2, false);
    }

    protected Collection<Resource> getConnectionRel(ReadGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, Collection<Resource> matching) throws DatabaseException {
        return matching;
    }

    protected SymbolConnectionData customConnect(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, Resource connType) throws DatabaseException {
        return null;
    }

    protected Set<Resource> getConnectionTypes(ReadGraph g, Resource componentConRel1) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        HashSet<Resource> set = new HashSet<Resource>();
        set.addAll(g.getObjects(componentConRel1, sr.AllowsConnectionType));
        return set;
    }

    protected Set<Resource> getNonAssertedConnectionTypes(ReadGraph g, Resource componentConRel1) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        HashSet<Resource> set = new HashSet<Resource>();
        for (Statement s : g.getStatements(componentConRel1, sr.AllowsConnectionType)) {
            if (s.isAsserted(componentConRel1)) continue;
            set.add(s.getObject());
        }
        return set;
    }

    public SymbolConnectionData connect(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, boolean forceFlag) throws DatabaseException {
        if (this.equals(symbolConf2)) {
            if (PREVENT_SELF_CONNECTIONS) {
                String err = "Preventing connection to self: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(componentConRel1) + " " + componentConRel1 + " " + g.getPossibleURI(componentConRel2) + " " + componentConRel2;
                Logger.defaultLogError((String)err);
                return new ConnectionErrorImpl(err);
            }
            if (componentConRel1.equals(componentConRel2)) {
                String err = "Preventing connection to self: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(componentConRel1) + " " + componentConRel1 + " " + g.getPossibleURI(componentConRel2) + " " + componentConRel2;
                Logger.defaultLogError((String)err);
                return new ConnectionErrorImpl(err);
            }
        }
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        Set<Resource> connType1 = this.getConnectionTypes((ReadGraph)g, componentConRel1);
        Set<Resource> connType2 = this.getConnectionTypes((ReadGraph)g, componentConRel2);
        Collection<Resource> matching = new HashSet<Resource>();
        for (Resource r : connType2) {
            if (!connType1.contains(r)) continue;
            matching.add(r);
        }
        if (matching.size() > 1) {
            matching = this.getConnectionRel((ReadGraph)g, symbolConf2, componentConRel1, componentConRel2, matching);
        }
        Resource usedConnType = null;
        if (matching.size() != 1) {
            String err = USE_UNRELIABLE_CONNECT ? "Unreliable connect " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " to " + symbolConf2.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)symbolConf2.component) + " cannot find proper connection type, using Name Reference" : "Unable to connect " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " to " + symbolConf2.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)symbolConf2.component) + " cannot find proper connection type for terminals " + g.getPossibleURI(componentConRel1) + " " + componentConRel1 + " " + g.getPossibleURI(componentConRel2) + " " + componentConRel2;
            Logger.defaultLogInfo((String)err);
            return new ConnectionErrorImpl(err);
        }
        usedConnType = (Resource)matching.iterator().next();
        SymbolConnectionData data = this.customConnect(g, symbolConf2, componentConRel1, componentConRel2, usedConnType);
        if (data == null) {
            if (!forceFlag && this.diagram.equals(symbolConf2.diagram)) {
                return this._connect(g, symbolConf2, componentConRel1, componentConRel2, usedConnType);
            }
            return this.connectWithFlag(g, symbolConf2, componentConRel1, componentConRel2, usedConnType);
        }
        return data;
    }

    public SymbolConnectionData connectElement(WriteGraph g, Symbol symbolConf2, Resource elementConRel1, Resource elementConRel2) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)g);
        Resource componentConRel1 = g.getPossibleObject(elementConRel1, mod.DiagramConnectionRelationToConnectionRelation);
        Resource componentConRel2 = g.getPossibleObject(elementConRel2, mod.DiagramConnectionRelationToConnectionRelation);
        if (componentConRel1 != null && componentConRel2 != null) {
            return this.connect(g, symbolConf2, componentConRel1, componentConRel2);
        }
        Collection<Object> connType1 = Collections.EMPTY_LIST;
        Collection<Object> connType2 = Collections.EMPTY_LIST;
        if (componentConRel1 != null) {
            connType1 = this.getConnectionTypes((ReadGraph)g, componentConRel1);
            if (connType1.size() > 1) {
                connType1 = this.getNonAssertedConnectionTypes((ReadGraph)g, componentConRel1);
            }
        } else if (componentConRel2 != null && (connType2 = this.getConnectionTypes((ReadGraph)g, componentConRel2)).size() > 1) {
            connType2 = this.getNonAssertedConnectionTypes((ReadGraph)g, componentConRel2);
        }
        Resource usedConnType = null;
        if (connType1.size() == 1) {
            usedConnType = (Resource)connType1.iterator().next();
        } else if (connType2.size() == 1) {
            usedConnType = (Resource)connType2.iterator().next();
        } else {
            String err = "Cannot locate connection type for: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        if (!this.diagram.equals(symbolConf2.diagram)) {
            String err = "Element connections must be done on the same diagram: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        return this.connectElement(g, symbolConf2, elementConRel1, elementConRel2, usedConnType);
    }

    public SymbolConnectionData connectElement(WriteGraph g, Symbol symbolConf2, Resource elementConRel1, Resource elementConRel2, Resource usedConnType) throws DatabaseException {
        SymbolConnectionData data;
        if (this.equals(symbolConf2)) {
            if (PREVENT_SELF_CONNECTIONS) {
                String err = "Preventing connection to self: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
                Logger.defaultLogError((String)err);
                return new ConnectionErrorImpl(err);
            }
            if (elementConRel1.equals(elementConRel2)) {
                String err = "Preventing connection to self: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
                Logger.defaultLogError((String)err);
                return new ConnectionErrorImpl(err);
            }
        }
        if ((data = this.customConnect(g, symbolConf2, elementConRel1, elementConRel2, usedConnType)) == null) {
            return this._connectElement(g, symbolConf2, elementConRel1, elementConRel2, usedConnType);
        }
        return data;
    }

    public SymbolConnectionData connect(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, Resource connectionType) throws DatabaseException {
        if (this.diagram.equals(symbolConf2.diagram)) {
            return this._connect(g, symbolConf2, componentConRel1, componentConRel2, connectionType);
        }
        return this.connectWithFlag(g, symbolConf2, componentConRel1, componentConRel2, connectionType);
    }

    protected SymbolConnectionData connectToExisting(WriteGraph g, Symbol symbolConf2, Symbol current, Resource componentConRel1, Resource componentConRel2, Resource connectorType, boolean firstSame) throws DatabaseException {
        return new ConnectionErrorImpl("Symbol is already connected");
    }

    private SymbolConnectionData _connect(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, Resource connectorType) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 s = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        if (g.isInstanceOf(componentConRel1, b.FunctionalRelation) && this.getSingleConnected((ReadGraph)g, componentConRel1) != null) {
            Symbol current = this.getSingleConnected((ReadGraph)g, componentConRel1);
            if (current.component.equals(symbolConf2.component)) {
                return new SymbolExistsImpl();
            }
            return this.connectToExisting(g, symbolConf2, current, componentConRel1, componentConRel2, connectorType, true);
        }
        if (g.isInstanceOf(componentConRel2, b.FunctionalRelation) && symbolConf2.getSingleConnected((ReadGraph)g, componentConRel2) != null) {
            Symbol current = symbolConf2.getSingleConnected((ReadGraph)g, componentConRel2);
            if (current.component.equals(this.component)) {
                return new SymbolExistsImpl();
            }
            return this.connectToExisting(g, symbolConf2, current, componentConRel1, componentConRel2, connectorType, false);
        }
        Resource moduleConnection = g.newResource();
        g.claim(moduleConnection, b.InstanceOf, s.Connection);
        g.claim(this.component, componentConRel1, moduleConnection);
        g.claim(symbolConf2.component, componentConRel2, moduleConnection);
        Resource diagramConnection = g.newResource();
        g.claim(diagramConnection, b.InstanceOf, d.RouteGraphConnection);
        DiagramUtils.addElementFirst(g, this.diagram, diagramConnection);
        g.claim(diagramConnection, s.HasConnectionType, connectorType);
        Resource elementConRel1 = Symbol.getDiagramConnectionRelation((ReadGraph)g, this.element, componentConRel1);
        Resource connectorRel1 = g.getPossibleObject(componentConRel1, s.HasAttachmentRelation);
        if (connectorRel1 == null) {
            connectorRel1 = d.HasPlainConnector;
        }
        Resource connector1 = g.newResource();
        g.claim(connector1, b.InstanceOf, d.Connector);
        g.claim(this.element, elementConRel1, connector1);
        g.claim(diagramConnection, connectorRel1, connector1);
        Resource elementConRel2 = Symbol.getDiagramConnectionRelation((ReadGraph)g, symbolConf2.element, componentConRel2);
        Resource connectorRel2 = g.getPossibleObject(componentConRel2, s.HasAttachmentRelation);
        if (connectorRel2 == null) {
            connectorRel2 = d.HasArrowConnector;
        }
        Resource connector2 = g.newResource();
        g.claim(connector2, b.InstanceOf, d.Connector);
        g.claim(symbolConf2.element, elementConRel2, connector2);
        g.claim(diagramConnection, connectorRel2, connector2);
        g.claim(connector1, d.AreConnected, connector2);
        g.claim(moduleConnection, m.ConnectionToDiagramConnection, diagramConnection);
        return new ConnectorDataImpl(diagramConnection);
    }

    private SymbolConnectionData _connectElement(WriteGraph g, Symbol symbolConf2, Resource elementConRel1, Resource elementConRel2, Resource connectorType) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 s = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        if (g.isInstanceOf(elementConRel1, b.FunctionalRelation) && this.getDiagramSingleConnected((ReadGraph)g, elementConRel1) != null) {
            Symbol current = this.getDiagramSingleConnected((ReadGraph)g, elementConRel1);
            if (current.component.equals(symbolConf2.component)) {
                return new SymbolExistsImpl();
            }
            String err = "Cannot connect, terminal 1 is reserved: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        if (g.isInstanceOf(elementConRel2, b.FunctionalRelation) && symbolConf2.getDiagramSingleConnected((ReadGraph)g, elementConRel2) != null) {
            Symbol current = symbolConf2.getDiagramSingleConnected((ReadGraph)g, elementConRel2);
            if (current.component.equals(this.component)) {
                return new SymbolExistsImpl();
            }
            String err = "Cannot connect, terminal 2 is reserved: " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " terminals: " + g.getPossibleURI(elementConRel1) + " " + elementConRel1 + " " + g.getPossibleURI(elementConRel2) + " " + elementConRel2;
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        Resource diagramConnection = g.newResource();
        g.claim(diagramConnection, b.InstanceOf, d.RouteGraphConnection);
        DiagramUtils.addElementFirst(g, this.diagram, diagramConnection);
        g.claim(diagramConnection, s.HasConnectionType, connectorType);
        Resource connectorRel1 = d.HasPlainConnector;
        Resource connector1 = g.newResource();
        g.claim(connector1, b.InstanceOf, d.Connector);
        g.claim(this.element, elementConRel1, connector1);
        g.claim(diagramConnection, connectorRel1, connector1);
        Resource connectorRel2 = d.HasArrowConnector;
        Resource connector2 = g.newResource();
        g.claim(connector2, b.InstanceOf, d.Connector);
        g.claim(symbolConf2.element, elementConRel2, connector2);
        g.claim(diagramConnection, connectorRel2, connector2);
        g.claim(connector1, d.AreConnected, connector2);
        return new ConnectorDataImpl(diagramConnection);
    }

    private SymbolConnectionData connectWithFlag(WriteGraph g, Symbol symbolConf2, Resource componentConRel1, Resource componentConRel2, Resource connectionType) throws DatabaseException {
        Diagram diagram2 = symbolConf2.diagram;
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 s = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        if (g.isInstanceOf(componentConRel1, l0.FunctionalRelation) && this.getSingleConnected((ReadGraph)g, componentConRel1) != null) {
            String err = "Cannot flag connect " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " to " + symbolConf2.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)symbolConf2.component) + " since the first terminal is already reserved";
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        if (g.isInstanceOf(componentConRel2, l0.FunctionalRelation) && symbolConf2.getSingleConnected((ReadGraph)g, componentConRel2) != null) {
            String err = "Cannot flag connect " + this.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.component) + " to " + symbolConf2.component + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)symbolConf2.component) + " since the second terminal is already reserved";
            Logger.defaultLogError((String)err);
            return new ConnectionErrorImpl(err);
        }
        double t = 20.0;
        double[] t1 = this.getSymbolTranslation((ReadGraph)g);
        double[] t2 = symbolConf2.getSymbolTranslation((ReadGraph)g);
        Object flag1 = this.diagram.addElement(g, d.Flag, t1[0] + t, t1[1]);
        Object flag2 = diagram2.addElement(g, d.Flag, t2[0] - t, t2[1]);
        Resource connectionJoin = g.newResource();
        g.claim(connectionJoin, l0.InstanceOf, s.ConnectionJoin);
        g.claim(this.diagram.getComposite(), s.HasConnectionJoin, connectionJoin);
        g.claim(diagram2.getComposite(), s.HasConnectionJoin, connectionJoin);
        Resource connection1 = g.newResource();
        g.claim(connection1, l0.InstanceOf, s.Connection);
        Resource connection2 = g.newResource();
        g.claim(connection2, l0.InstanceOf, s.Connection);
        g.claim(this.component, componentConRel1, connection1);
        g.claim(symbolConf2.component, componentConRel2, connection2);
        g.claim(connection1, s.IsJoinedBy, connectionJoin);
        g.claim(connection2, s.IsJoinedBy, connectionJoin);
        g.claim(((Symbol)flag1).element, d.FlagIsJoinedBy, connectionJoin);
        g.claim(((Symbol)flag2).element, d.FlagIsJoinedBy, connectionJoin);
        Resource diagConnection1 = g.newResource();
        g.claim(diagConnection1, l0.InstanceOf, d.RouteGraphConnection);
        DiagramUtils.addElementFirst(g, this.diagram, diagConnection1);
        g.claim(diagConnection1, s.HasConnectionType, connectionType);
        Resource diagConnection2 = g.newResource();
        g.claim(diagConnection2, l0.InstanceOf, d.RouteGraphConnection);
        DiagramUtils.addElementFirst(g, diagram2, diagConnection2);
        g.claim(diagConnection2, s.HasConnectionType, connectionType);
        g.claim(connection1, m.ConnectionToDiagramConnection, diagConnection1);
        g.claim(connection2, m.ConnectionToDiagramConnection, diagConnection2);
        Resource isConnected1 = Symbol.getDiagramConnectionRelation((ReadGraph)g, this.element, componentConRel1);
        Resource connector1_1 = g.newResource();
        g.claim(connector1_1, l0.InstanceOf, d.Connector);
        g.claim(this.element, isConnected1, connector1_1);
        g.claim(diagConnection1, d.HasPlainConnector, connector1_1);
        Resource connector1_2 = g.newResource();
        g.claim(connector1_2, l0.InstanceOf, d.Connector);
        g.claim(((Symbol)flag1).element, d.Flag_ConnectionPoint, connector1_2);
        g.claim(diagConnection1, d.HasArrowConnector, connector1_2);
        g.claim(connector1_1, d.AreConnected, connector1_2);
        Resource isConnected2 = Symbol.getDiagramConnectionRelation((ReadGraph)g, symbolConf2.element, componentConRel2);
        Resource connector2_1 = g.newResource();
        g.claim(connector2_1, l0.InstanceOf, d.Connector);
        g.claim(((Symbol)flag2).element, d.Flag_ConnectionPoint, connector2_1);
        g.claim(diagConnection2, d.HasPlainConnector, connector2_1);
        Resource connector2_2 = g.newResource();
        g.claim(connector2_2, l0.InstanceOf, d.Connector);
        g.claim(symbolConf2.element, isConnected2, connector2_2);
        g.claim(diagConnection2, d.HasArrowConnector, connector2_2);
        g.claim(connector2_1, d.AreConnected, connector2_2);
        return new FlagConnectionDataImpl((Symbol)flag1, (Symbol)flag2, diagConnection1, diagConnection2);
    }

    public static Resource getDiagramConnectionRelation(ReadGraph g, Resource element, Resource componentConnRel) throws DatabaseException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Collection diagramConnectionRels = g.getObjects(componentConnRel, m.ConnectionRelationToDiagramConnectionRelation);
        if (diagramConnectionRels.size() == 1) {
            return (Resource)diagramConnectionRels.iterator().next();
        }
        if (diagramConnectionRels.size() > 1) {
            ArrayList<Resource> matching = new ArrayList<Resource>();
            for (Resource r : diagramConnectionRels) {
                if (!g.hasStatement(element, r)) continue;
                matching.add(r);
            }
            if (matching.size() == 1) {
                return (Resource)matching.get(0);
            }
        }
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        Collection elementTypes = g.getObjects(element, b.InstanceOf);
        if (elementTypes.size() != 1) {
            throw new RuntimeException("Cannot handle multi-instances " + element + " " + NameUtils.getSafeName((ReadGraph)g, (Resource)element));
        }
        Resource elementType = (Resource)elementTypes.iterator().next();
        Collection rels = StructuralUtils.getConnectionRelations((ReadGraph)g, (Resource)elementType);
        if (rels.size() == 1) {
            return (Resource)rels.iterator().next();
        }
        for (Resource rel : rels) {
            if (!diagramConnectionRels.contains(rel)) continue;
            return rel;
        }
        throw new RuntimeException("Cannot find diagram level relation for relation " + NameUtils.getSafeName((ReadGraph)g, (Resource)componentConnRel) + " " + componentConnRel + " , element " + NameUtils.getSafeName((ReadGraph)g, (Resource)element) + " " + element + " , elementType " + NameUtils.getSafeName((ReadGraph)g, (Resource)elementType) + " " + elementType);
    }

    public static Resource getComponentConnectionRelation(ReadGraph g, Resource diagraromConnRel) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        return g.getSingleObject(diagraromConnRel, mr.DiagramConnectionRelationToConnectionRelation);
    }

    public Symbol getSingleConnected(ReadGraph g, Resource componentConRel) throws DatabaseException {
        Collection<Symbol> symbols = this.getConnected(g, componentConRel);
        if (symbols.size() > 1) {
            throw new NoSingleResultException("Symbol " + this.component + " is connected more than once using relation " + componentConRel);
        }
        if (symbols.size() == 1) {
            return symbols.iterator().next();
        }
        return null;
    }

    public Symbol getSingleConnected(ReadGraph g, Resource componentConRel, Resource otherComponentConRel) throws DatabaseException {
        Collection<Symbol> symbols = this.getConnected(g, componentConRel, otherComponentConRel);
        if (symbols.size() > 1) {
            throw new NoSingleResultException("Symbol " + this.component + " is connected more than once using relation " + componentConRel);
        }
        if (symbols.size() == 1) {
            return symbols.iterator().next();
        }
        return null;
    }

    public Collection<Symbol> getConnected(ReadGraph g, Resource componentConRel, Resource otherComponentConRel) throws DatabaseException {
        assert (componentConRel != null);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        Collection modConn1s = g.getObjects(this.component, componentConRel);
        for (Resource modConn1 : modConn1s) {
            Collection connected = g.getStatements(modConn1, sr.Connects);
            Collection connectionJoins = g.getObjects(modConn1, sr.IsJoinedBy);
            ArrayList<Resource> connectedComponents = new ArrayList<Resource>();
            for (Statement stm : connected) {
                if (stm.getObject().equals(this.component) || !g.getInverse(stm.getPredicate()).equals(otherComponentConRel)) continue;
                connectedComponents.add(stm.getObject());
            }
            for (Resource connectionJoin : connectionJoins) {
                Collection joinedConns = g.getObjects(connectionJoin, sr.Joins);
                for (Resource conn : joinedConns) {
                    if (conn.equals(modConn1)) continue;
                    for (Statement stm : g.getStatements(conn, sr.Connects)) {
                        if (!g.getInverse(stm.getPredicate()).equals(otherComponentConRel)) continue;
                        connectedComponents.add(stm.getObject());
                    }
                }
            }
            for (Resource connectedComponent : connectedComponents) {
                Resource pointElem = g.getSingleObject(connectedComponent, mr.ComponentToElement);
                Diagram diag = this.diagram.fromExisting(g, g.getSingleObject(connectedComponent, l0.PartOf));
                result.add((Symbol)diag.getSymbol(g, pointElem, connectedComponent));
            }
        }
        return result;
    }

    public Collection<Symbol> getConnected(ReadGraph g, Resource componentConRel) throws DatabaseException {
        assert (componentConRel != null);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Collection modConn1s = g.getObjects(this.component, componentConRel);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Resource modConn1 : modConn1s) {
            Collection connected = g.getObjects(modConn1, sr.Connects);
            Collection connectionJoins = g.getObjects(modConn1, sr.IsJoinedBy);
            ArrayList<Resource> connectedComponents = new ArrayList<Resource>();
            for (Resource r : connected) {
                if (r.equals(this.component)) continue;
                connectedComponents.add(r);
            }
            for (Resource connectionJoin : connectionJoins) {
                Collection joinedConns = g.getObjects(connectionJoin, sr.Joins);
                for (Resource conn : joinedConns) {
                    if (conn.equals(modConn1)) continue;
                    for (Resource obj : g.getObjects(conn, sr.Connects)) {
                        connectedComponents.add(obj);
                    }
                }
            }
            for (Resource connectedComponent : connectedComponents) {
                Resource pointElem = g.getSingleObject(connectedComponent, mr.ComponentToElement);
                Diagram diag = this.diagram.fromExisting(g, g.getSingleObject(connectedComponent, l0.PartOf));
                result.add((Symbol)diag.getSymbol(g, pointElem, connectedComponent));
            }
        }
        return result;
    }

    public Collection<Symbol> getDiagramConnected(ReadGraph g, Resource diagramConnRel, Resource otherConnRel) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Collection connectors = g.getObjects(this.element, diagramConnRel);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Resource connector : connectors) {
            Resource otherConnector = g.getSingleObject(connector, dr.AreConnected);
            if (g.isInstanceOf(otherConnector, dr.Connector)) {
                this.getConnectorConnectors(g, otherConnector, otherConnRel, result);
                continue;
            }
            if (g.isInstanceOf(otherConnector, dr.RouteLine)) {
                this.getBranchPointConnectors(g, connector, otherConnector, otherConnRel, result);
                continue;
            }
            throw new DatabaseException("Connector " + g.getPossibleURI(otherConnector) + " " + otherConnector + " han unknown type");
        }
        return result;
    }

    private void getConnectorConnectors(ReadGraph g, Resource connector, Resource otherConnRel, Collection<Symbol> result) throws DatabaseException {
        Resource rel;
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Collection stms = g.getStatements(connector, sr.Connects);
        Statement stm = null;
        for (Statement s : stms) {
            if (g.isInstanceOf(s.getObject(), dr.Connection)) continue;
            stm = s;
        }
        if (stm == null) {
            return;
        }
        if (otherConnRel != null && !(rel = g.getInverse(stm.getPredicate())).equals(otherConnRel)) {
            return;
        }
        Resource element = stm.getObject();
        result.add((Symbol)this.diagram.getSymbol(g, element));
    }

    private void getBranchPointConnectors(ReadGraph g, Resource origin, Resource branchPoint, Resource otherConnRel, Collection<Symbol> result) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Collection branchConnected = g.getObjects(branchPoint, dr.AreConnected);
        for (Resource branchConnector : branchConnected) {
            if (branchConnector.equals(origin)) continue;
            if (g.isInstanceOf(branchConnector, dr.Connector)) {
                this.getConnectorConnectors(g, branchConnector, otherConnRel, result);
                continue;
            }
            if (g.isInstanceOf(branchConnector, dr.RouteLine)) {
                this.getBranchPointConnectors(g, branchPoint, branchConnector, otherConnRel, result);
                continue;
            }
            throw new DatabaseException("Connector " + g.getPossibleURI(branchConnector) + " " + branchConnector + " han unknown type");
        }
    }

    public Collection<Symbol> getDiagramConnected(ReadGraph g, Resource diagramConnRel) throws DatabaseException {
        return this.getDiagramConnected(g, diagramConnRel, null);
    }

    public Collection<Symbol> getDiagramInverseConnected(ReadGraph g, Resource otherConnRel) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        return this.getDiagramConnected(g, sr.IsConnectedTo, otherConnRel);
    }

    public Collection<Symbol> getDiagramConnected(ReadGraph g) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        return this.getDiagramConnected(g, sr.IsConnectedTo, null);
    }

    public Symbol getDiagramSingleConnected(ReadGraph g, Resource diagramConnRel) throws DatabaseException {
        Collection<Symbol> symbols = this.getDiagramConnected(g, diagramConnRel);
        if (symbols.size() > 1) {
            throw new NoSingleResultException("Symbol " + this.element + " has more than one connection with " + diagramConnRel);
        }
        if (symbols.size() == 1) {
            return symbols.iterator().next();
        }
        return null;
    }

    public Symbol getOtherFlag(ReadGraph g) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource connectionJoin = g.getPossibleObject(this.element, dr.FlagIsJoinedBy);
        if (connectionJoin == null) {
            return null;
        }
        Collection flags = g.getObjects(connectionJoin, dr.JoinsFlag);
        Resource otherFlag = null;
        for (Resource f : flags) {
            if (f.equals(this.element)) continue;
            otherFlag = f;
            break;
        }
        if (otherFlag == null) {
            return null;
        }
        Resource otherDiagramR = OrderedSetUtils.getSingleOwnerList((ReadGraph)g, otherFlag);
        Diagram otherDiagram = this.diagram.fromExisting(g, otherDiagramR);
        return otherDiagram.getSymbol(g, otherFlag, null);
    }

    public double[] getSymbolTranslation(ReadGraph g) throws DatabaseException {
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Object e = this.element;
        AffineTransform at = new AffineTransform();
        while (e != null) {
            double[] transform = (double[])g.getPossibleRelatedValue(e, d.HasTransform);
            if (transform == null) break;
            AffineTransform at2 = new AffineTransform(transform);
            at.preConcatenate(at2);
            Resource component = g.getPossibleObject(e, mr.HasParentComponent);
            e = component != null ? g.getPossibleObject(component, mr.ComponentToElement) : null;
        }
        return new double[]{at.getTranslateX(), at.getTranslateY()};
    }

    public double[] getSymbolTransformation(ReadGraph g) throws DatabaseException {
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        double[] transform = (double[])g.getPossibleRelatedValue(this.element, d.HasTransform);
        return transform;
    }

    public void setSymbolTranslation(WriteGraph g, double x, double y) throws DatabaseException {
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        g.claimLiteral(this.element, d.HasTransform, g2d.Transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, x, y});
    }

    public void setSymbolTransformation(WriteGraph g, AffineTransform at) throws DatabaseException {
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        double[] arr = new double[6];
        at.getMatrix(arr);
        g.claimLiteral(this.element, d.HasTransform, g2d.Transform, (Object)arr);
    }

    public void setScale(WriteGraph g, double scale) throws DatabaseException {
        DiagramResource d = DiagramResource.getInstance((ReadGraph)g);
        double[] transform = (double[])g.getPossibleRelatedValue(this.element, d.HasTransform);
        g.claimLiteral(this.element, d.HasTransform, (Object)new double[]{scale, 0.0, 0.0, scale, transform[4], transform[5]});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Symbol other = (Symbol)o;
        return this.element.equals(other.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public static Resource getComponentTypeFromSymbolType(ReadGraph g, Resource symbolType) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Resource component = g.getPossibleObject(symbolType, m.SymbolToComponentType);
        return component;
    }

    public static Resource getSymbolTypeFromComponentType(ReadGraph g, Resource componentType) throws NoSingleResultException, ServiceException, ManyObjectsForFunctionalRelationException {
        ModelingResources m = ModelingResources.getInstance((ReadGraph)g);
        Collection symbols = g.getObjects(componentType, m.ComponentTypeToSymbol);
        if (symbols.size() == 0) {
            return null;
        }
        return (Resource)symbols.iterator().next();
    }

    public void remove(WriteGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        OrderedSetUtils.remove((WriteGraph)g, (Resource)this.diagram.getDiagram(), (Resource)this.element);
        if (this.component != null) {
            g.deny(this.component, L0.PartOf);
        }
        Collection statements = g.getStatements(this.element, STR.IsConnectedTo);
        for (Statement s : statements) {
            if (!g.isInstanceOf(s.getObject(), DIA.Connector)) continue;
            Resource connectedConnector = g.getPossibleObject(s.getObject(), DIA.AreConnected);
            if (connectedConnector != null) {
                g.deny(connectedConnector);
            }
            g.deny(s.getObject());
        }
        if (this.component != null) {
            statements = g.getStatements(this.component, STR.IsConnectedTo);
            for (Statement s : statements) {
                if (!g.isInstanceOf(s.getObject(), STR.Connection)) continue;
                g.deny(s.getObject());
            }
        }
        g.deny(this.element);
        if (this.component != null) {
            g.deny(this.component);
        }
    }

    public void dispose() {
        this.diagram = null;
        this.component = null;
        this.element = null;
    }

    public void setComponentValue(WriteGraph graph, Resource property, double value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, float value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, boolean value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, int value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, String value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, double[] value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, float[] value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, int[] value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setComponentValue(WriteGraph graph, Resource property, boolean[] value) throws DatabaseException {
        Symbol.setValue(graph, this.component, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, double value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, float value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, boolean value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, int value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, double[] value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, float[] value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, int[] value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public void setElementValue(WriteGraph graph, Resource property, boolean[] value) throws DatabaseException {
        Symbol.setValue(graph, this.element, property, value);
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, double value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.Double.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE);
        } else if (l0.Float.equals(range)) {
            graph.claimLiteral(object, property, (Object)Float.valueOf((float)value), (Binding)Bindings.FLOAT);
        } else if (l0.Integer.equals(range)) {
            graph.claimLiteral(object, property, (Object)((int)value), (Binding)Bindings.INTEGER);
        } else if (l0.Long.equals(range)) {
            graph.claimLiteral(object, property, (Object)((long)value), (Binding)Bindings.LONG);
        } else if (l0.Boolean.equals(range)) {
            graph.claimLiteral(object, property, (Object)(value > 0.0 ? 1 : 0), (Binding)Bindings.BOOLEAN);
        } else if (l0.String.equals(range)) {
            graph.claimLiteral(object, property, (Object)Double.toString(value), (Binding)Bindings.STRING);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, float value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.Double.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE);
        } else if (l0.Float.equals(range)) {
            graph.claimLiteral(object, property, (Object)Float.valueOf(value), (Binding)Bindings.FLOAT);
        } else if (l0.Integer.equals(range)) {
            graph.claimLiteral(object, property, (Object)((int)value), (Binding)Bindings.INTEGER);
        } else if (l0.Long.equals(range)) {
            graph.claimLiteral(object, property, (Object)((long)value), (Binding)Bindings.LONG);
        } else if (l0.Boolean.equals(range)) {
            graph.claimLiteral(object, property, (Object)(value > 0.0f ? 1 : 0), (Binding)Bindings.BOOLEAN);
        } else if (l0.String.equals(range)) {
            graph.claimLiteral(object, property, (Object)Float.toString(value), (Binding)Bindings.STRING);
        } else {
            graph.claimLiteral(object, property, (Object)Float.valueOf(value), (Binding)Bindings.FLOAT);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, int value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.Double.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE);
        } else if (l0.Float.equals(range)) {
            graph.claimLiteral(object, property, (Object)Float.valueOf(value), (Binding)Bindings.FLOAT);
        } else if (l0.Integer.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.INTEGER);
        } else if (l0.Long.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.LONG);
        } else if (l0.Boolean.equals(range)) {
            graph.claimLiteral(object, property, (Object)(value > 0 ? 1 : 0), (Binding)Bindings.BOOLEAN);
        } else if (l0.String.equals(range)) {
            graph.claimLiteral(object, property, (Object)Integer.toString(value), (Binding)Bindings.STRING);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.INTEGER);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, String value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (range == null) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.STRING);
        } else if (graph.isInheritedFrom(range, l0.String)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.STRING);
        } else if (graph.isInheritedFrom(range, l0.Double)) {
            graph.claimLiteral(object, property, (Object)Double.parseDouble(value), (Binding)Bindings.DOUBLE);
        } else if (graph.isInheritedFrom(range, l0.Float)) {
            graph.claimLiteral(object, property, (Object)Float.valueOf(Float.parseFloat(value)), (Binding)Bindings.FLOAT);
        } else if (graph.isInheritedFrom(range, l0.Integer)) {
            graph.claimLiteral(object, property, (Object)Integer.parseInt(value), (Binding)Bindings.INTEGER);
        } else if (graph.isInheritedFrom(range, l0.Long)) {
            graph.claimLiteral(object, property, (Object)Long.parseLong(value), (Binding)Bindings.LONG);
        } else if (graph.isInheritedFrom(range, l0.Boolean)) {
            graph.claimLiteral(object, property, (Object)Boolean.parseBoolean(value), (Binding)Bindings.BOOLEAN);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.STRING);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, boolean value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.Boolean.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.BOOLEAN);
        } else if (l0.String.equals(range)) {
            graph.claimLiteral(object, property, (Object)Boolean.toString(value), (Binding)Bindings.STRING);
        } else if (l0.Integer.equals(range)) {
            graph.claimLiteral(object, property, (Object)(value ? 1 : 0), (Binding)Bindings.INTEGER);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.BOOLEAN);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, double[] value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.DoubleArray.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE_ARRAY);
        } else if (l0.FloatArray.equals(range)) {
            float[] arr = new float[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = (float)value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.FLOAT_ARRAY);
        } else if (l0.IntegerArray.equals(range)) {
            int[] arr = new int[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = (int)value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.INT_ARRAY);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.DOUBLE_ARRAY);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, float[] value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.FloatArray.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.FLOAT_ARRAY);
        } else if (l0.DoubleArray.equals(range)) {
            double[] arr = new double[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.DOUBLE_ARRAY);
        } else if (l0.IntegerArray.equals(range)) {
            int[] arr = new int[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = (int)value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.INT_ARRAY);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.FLOAT_ARRAY);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, int[] value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.IntegerArray.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.INT_ARRAY);
        } else if (l0.DoubleArray.equals(range)) {
            double[] arr = new double[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.DOUBLE_ARRAY);
        } else if (l0.FloatArray.equals(range)) {
            float[] arr = new float[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = value[i];
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.FLOAT_ARRAY);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.INT_ARRAY);
        }
    }

    public static void setValue(WriteGraph graph, Resource object, Resource property, boolean[] value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource range = graph.getPossibleObject(property, l0.HasRange);
        if (l0.BooleanArray.equals(range)) {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.BOOLEAN_ARRAY);
        } else if (l0.IntegerArray.equals(range)) {
            int[] arr = new int[value.length];
            int i = 0;
            while (i < value.length) {
                arr[i] = value[i] ? 1 : 0;
                ++i;
            }
            graph.claimLiteral(object, property, (Object)arr, (Binding)Bindings.INT_ARRAY);
        } else {
            graph.claimLiteral(object, property, (Object)value, (Binding)Bindings.BOOLEAN_ARRAY);
        }
    }

    public static interface ConnectionError
    extends SymbolConnectionData {
        public String getReason();
    }

    private static class ConnectionErrorImpl
    implements ConnectionError {
        private String error;

        public ConnectionErrorImpl(String error) {
            this.error = error;
        }

        @Override
        public String getReason() {
            return this.error;
        }
    }

    private static class ConnectorDataImpl
    implements DiagramConnectionData {
        private Resource[] connectors;

        public ConnectorDataImpl(Resource ... connectors) {
            this.connectors = connectors;
        }

        @Override
        public Resource getConnection(int index) {
            return this.connectors[index];
        }

        @Override
        public int getConnectionCount() {
            return this.connectors.length;
        }
    }

    public static interface DiagramConnectionData
    extends SymbolConnectionData {
        public int getConnectionCount();

        public Resource getConnection(int var1);
    }

    public static interface FlagConnectionData
    extends SymbolConnectionData {
        public Symbol getFirstFlag();

        public Symbol getSecondFlag();
    }

    private static class FlagConnectionDataImpl
    implements FlagConnectionData,
    DiagramConnectionData {
        private Symbol firstFlag;
        private Symbol secondFlag;
        private Resource[] connectors;

        public FlagConnectionDataImpl(Symbol firstFlag, Symbol secondFlag, Resource ... connectors) {
            this.firstFlag = firstFlag;
            this.secondFlag = secondFlag;
            this.connectors = connectors;
        }

        @Override
        public Symbol getFirstFlag() {
            return this.firstFlag;
        }

        @Override
        public Symbol getSecondFlag() {
            return this.secondFlag;
        }

        @Override
        public Resource getConnection(int index) {
            return this.connectors[index];
        }

        @Override
        public int getConnectionCount() {
            return this.connectors.length;
        }
    }

    public static interface MergeSymbolData
    extends SymbolConnectionData {
        public Symbol getResultSymbol();
    }

    public static interface PointConnectionData
    extends SymbolConnectionData {
        public Symbol getPoint();
    }

    public static interface SignalConnectionData
    extends SymbolConnectionData {
        public Resource getSignalComponent();
    }

    public static interface SymbolConnectionData {
    }

    public static interface SymbolExists
    extends SymbolConnectionData {
    }

    private static class SymbolExistsImpl
    implements SymbolExists {
        private SymbolExistsImpl() {
        }
    }
}

