/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.csg.scenegraph2.SchemaBuilder;
import org.simantics.g3d.csg.wizard.CSGExportModel;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.opencascade.OccTriangulator;

public class CSGBrepModelExporter
implements IRunnableWithProgress {
    CSGExportModel exportModel;

    public CSGBrepModelExporter(CSGExportModel exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        SubMonitor mon = progress.newChild(50, 0);
        try {
            try {
                this.exportModel(mon);
            }
            catch (IOException e) {
                mon.setCanceled(true);
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                mon.setCanceled(true);
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException {
        int taskSize = 50;
        mon.beginTask("Exporting model...", taskSize);
        mon.setTaskName("Initializing CSG model...");
        CSGrootNode rootNode = (CSGrootNode)((Object)Simantics.getSessionContext().getSession().syncRequest((Read)new Read<CSGrootNode>(){

            public CSGrootNode perform(ReadGraph graph) throws DatabaseException {
                IMappingSchema<Resource, Object> schema = SchemaBuilder.getSchema(graph);
                IMapping mapping = Mappings.createWithoutListening(schema);
                CSGrootNode rootNode = (CSGrootNode)((Object)mapping.map(graph, (Object)CSGBrepModelExporter.this.exportModel.getModel().getResource()));
                mapping.dispose();
                return rootNode;
            }
        }));
        mon.worked(40);
        mon.setTaskName("Creating solid geometry...");
        ArrayList<TopoDS_Shape> shapes = new ArrayList<TopoDS_Shape>();
        for (ICSGnode node : rootNode.getChild()) {
            TopoDS_Shape shape = node.getGeometry();
            if (shape == null) continue;
            shapes.add(shape);
        }
        if (shapes.size() == 0) {
            mon.setTaskName("Nothing to export.");
            mon.setCanceled(true);
            return;
        }
        TopoDS_Shape compound = null;
        if (shapes.size() > 1) {
            OccTriangulator.makeCompound((TopoDS_Shape[])shapes.toArray(new TopoDS_Shape[shapes.size()]));
            for (TopoDS_Shape shape : shapes) {
                shape.delete();
            }
        } else {
            compound = (TopoDS_Shape)shapes.get(0);
        }
        mon.worked(50);
        mon.setTaskName("Writing file...");
        OccTriangulator.exportBREP((TopoDS_Shape)compound, (String)this.exportModel.getExportLocation().getAbsolutePath());
        compound.delete();
        mon.setWorkRemaining(0);
    }
}

