/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.simantics.utils.datastructures.ImmutableCollection;
import org.simantics.utils.datastructures.ImmutableIterator;

public class Union<T>
extends ImmutableCollection<T> {
    private List<Collection<T>> parts;

    public Union(int partCount) {
        this.parts = new ArrayList<Collection<T>>(partCount);
    }

    public void add(Collection<T> part) {
        this.parts.add(part);
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> part : this.parts) {
            if (!part.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> part : this.parts) {
            if (!part.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(){
            Iterator<Collection<T>> partIterator;
            Iterator<T> iterator;
            {
                this.partIterator = Union.this.parts.iterator();
                this.iterator = null;
            }

            @Override
            public boolean hasNext() {
                while (this.iterator == null || !this.iterator.hasNext()) {
                    if (!this.partIterator.hasNext()) {
                        return false;
                    }
                    this.iterator = this.partIterator.next().iterator();
                }
                return true;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.iterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int size() {
        int count = 0;
        for (Collection<T> part : this.parts) {
            count += part.size();
        }
        return count;
    }
}

