/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.ActiveRuns;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.region.ontology.DiagramRegionsResource;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelector {
    String name;
    String expression;
    Resource resource;
    Generator generator;
    Selector selector;
    Condition condition;
    private float[] color;
    static Logger LOG = LoggerFactory.getLogger(ElementSelector.class);
    static ElementSelectionResource ES;
    static Layer0 L0;
    static StructuralResource2 STR;
    static ModelingResources MOD;
    static DiagramResource DIA;
    static DistrictNetworkResource DN;
    private static Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(ElementSelector.class);
    }

    ElementSelector(ReadGraph graph, Resource resource) throws DatabaseException {
        L0 = Layer0.getInstance((ReadGraph)graph);
        ES = ElementSelectionResource.getInstance(graph);
        STR = StructuralResource2.getInstance((ReadGraph)graph);
        MOD = ModelingResources.getInstance((ReadGraph)graph);
        DIA = DiagramResource.getInstance((ReadGraph)graph);
        DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        this.resource = resource;
        try {
            this.name = (String)graph.getRelatedValue(resource, ElementSelector.L0.HasLabel);
            this.expression = ElementSelector.getExpression((RequestProcessor)graph, resource);
            float[] color = (float[])graph.getPossibleRelatedValue(resource, ElementSelector.ES.Selection_HasHighlightColor);
            this.color = color;
        }
        catch (DatabaseException e) {
            LOG.error("Error reading element selector", (Throwable)e);
            throw e;
        }
    }

    public static ElementSelector getSelector(RequestProcessor graph, Resource resource) throws DatabaseException {
        return (ElementSelector)graph.syncRequest((Read)new ElementSelectorQuery(resource));
    }

    public static String getExpression(RequestProcessor graph, Resource resource) throws DatabaseException {
        return (String)graph.syncRequest((Read)new SelectionExpressionRequest(resource));
    }

    public static Condition getCondition(RequestProcessor graph, Resource condition) throws DatabaseException {
        return (Condition)graph.syncRequest((Read)new SelectionConditionRequest(condition));
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public float[] getColor() {
        return this.color;
    }

    public void buildSelection(ReadGraph graph) throws DatabaseException {
        Resource selector = graph.getSingleObject(this.resource, ElementSelector.ES.Selection_HasSelector);
        Resource generator = graph.getSingleObject(this.resource, ElementSelector.ES.Selection_HasGenerator);
        Resource condition = graph.getPossibleObject(this.resource, ElementSelector.ES.Selection_HasCondition);
        this.selector = ElementSelector.buildSelector(graph, selector);
        this.generator = ElementSelector.buildGenerator(graph, generator);
        this.condition = ElementSelector.buildCondition(graph, condition);
    }

    public static Map<Resource, String> findDiagrams() {
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new Read<Map<Resource, String>>(){

                public Map<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    HashMap<Resource, String> result = new HashMap<Resource, String>();
                    Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
                    List composites = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)STR.Composite);
                    for (Resource r : composites) {
                        Resource parent;
                        Resource diagram = graph.getPossibleObject(r, MOD.CompositeToDiagram);
                        if (diagram == null || !graph.isInstanceOf(diagram, DN.Diagram) || (parent = graph.getPossibleObject(r, L0.PartOf)) == null || graph.isInheritedFrom(parent, STR.Component)) continue;
                        result.put(r, (String)graph.getRelatedValue(r, L0.HasName));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Query for model diagrams failed", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Variable getVariableForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Resource component = graph.getPossibleObject(element, ElementSelector.MOD.ElementToComponent);
        if (component != null) {
            Variable var = Variables.getVariable((ReadGraph)graph, (Resource)component);
            RVI realRvi = var.getRVI(graph);
            for (Resource activeModel : (Collection)graph.syncRequest((Read)new ActiveModels(Simantics.getProjectResource()))) {
                Variable v;
                for (Variable run : (Collection)graph.syncRequest((Read)new ActiveRuns(activeModel))) {
                    Variable v2 = realRvi.resolvePossible(graph, run);
                    if (v2 == null) continue;
                    return v2;
                }
                Variable configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)activeModel);
                if (configuration == null || (v = realRvi.resolvePossible(graph, configuration)) == null) continue;
                return v;
            }
        }
        return null;
    }

    public static Double getPropertyValue(ReadGraph graph, Resource element, String propertyName) {
        try {
            Number value;
            Variable v = ElementSelector.getVariableForElement(graph, element);
            if (v != null && (value = (Number)v.getPossiblePropertyValue(graph, propertyName)) != null) {
                return value.doubleValue();
            }
            Resource mappedElement = graph.getPossibleObject(element, ElementSelector.DN.MappedComponent);
            if (mappedElement != null) {
                return ElementSelector.getPropertyValue(graph, mappedElement, propertyName);
            }
        }
        catch (DatabaseException databaseException) {}
        return null;
    }

    public SelectionResult selectElementsFrom(ReadGraph graph, Resource model) throws DatabaseException {
        if (this.selector == null) {
            this.buildSelection(graph);
        }
        return this.gather(graph, model);
    }

    private static Generator buildGenerator(ReadGraph graph, Resource resource) throws DatabaseException {
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Generator)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid generator");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Model)) {
            return new ModelGenerator();
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Diagram)) {
            return new DiagramGenerator(graph.getSingleObject(resource, ElementSelector.ES.Generator_HasDiagram));
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Generator_Explicit)) {
            return new ExplicitGenerator(graph.getObjects(resource, ElementSelector.ES.Generator_HasSelectedElement));
        }
        throw new IllegalArgumentException("Unknown generator type " + graph.getURI(graph.getSingleType(resource)));
    }

    private static Selector buildSelector(ReadGraph graph, Resource resource) throws DatabaseException {
        Resource mapping;
        Selector s;
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Selector)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid selector");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.Selector_All)) {
            s = new All();
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.PropertySelector)) {
            s = new PropertySelector(graph, resource);
        } else {
            throw new IllegalArgumentException("Unknown selector type " + graph.getURI(graph.getSingleType(resource)));
        }
        s.componentType = mapping = graph.getPossibleObject(resource, ElementSelector.ES.Selector_HasMapping);
        return s;
    }

    private static Condition buildCondition(ReadGraph graph, Resource resource) throws DatabaseException {
        Condition cond;
        if (resource == null) {
            return null;
        }
        if (!graph.isInstanceOf(resource, ElementSelector.ES.Condition)) {
            throw new IllegalArgumentException("Resource " + resource + " is not a valid condition");
        }
        if (graph.isInstanceOf(resource, ElementSelector.ES.PropertyCondition)) {
            cond = new PropertyCondition(graph, resource);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.RegionCondition)) {
            cond = new RegionCondition(graph, resource);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.RouteCondition)) {
            cond = new RouteCondition(graph, resource);
        } else if (graph.isInstanceOf(resource, ElementSelector.ES.AggregateCondition)) {
            cond = new AggregateCondition(graph, resource);
        } else {
            throw new IllegalArgumentException("Unknown condition type " + graph.getURI(graph.getSingleType(resource)));
        }
        return cond;
    }

    private static String buildExpression(ReadGraph graph, Resource r) throws DatabaseException {
        if (graph.isInstanceOf(r, ElementSelector.ES.Selection)) {
            return ElementSelector.buildSelectionExpression(graph, r);
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Condition)) {
            return ElementSelector.buildConditionExpression(graph, r);
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Selector)) {
            return ElementSelector.buildSelectorExpression(graph, r);
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Generator)) {
            return ElementSelector.buildGeneratorExpression(graph, r);
        }
        throw new DatabaseException("Unsupported resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
    }

    private static String buildSelectionExpression(ReadGraph graph, Resource r) throws DatabaseException, NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        String exp = "select " + ElementSelector.getExpression((RequestProcessor)graph, graph.getSingleObject(r, ElementSelector.ES.Selection_HasSelector)) + " from " + ElementSelector.getExpression((RequestProcessor)graph, graph.getSingleObject(r, ElementSelector.ES.Selection_HasGenerator));
        Resource cond = graph.getPossibleObject(r, ElementSelector.ES.Selection_HasCondition);
        return cond != null ? String.valueOf(exp) + " where {" + ElementSelector.getExpression((RequestProcessor)graph, cond) + "}" : exp;
    }

    private static String buildGeneratorExpression(ReadGraph graph, Resource r) throws ServiceException, NoSingleResultException, DoesNotContainValueException, ManyObjectsForFunctionalRelationException, DatabaseException, AssumptionException, ValidationException {
        if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Model)) {
            return "model";
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Diagram)) {
            return "diagram \"" + graph.getRelatedValue(graph.getSingleObject(r, ElementSelector.ES.Generator_HasDiagram), ElementSelector.L0.HasName) + "\"";
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.Generator_Explicit)) {
            return "<list of " + graph.getObjects(r, ElementSelector.ES.Generator_HasSelectedElement).size() + " elements>";
        }
        throw new DatabaseException("Unsupported generator resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
    }

    private static String buildSelectorExpression(ReadGraph graph, Resource r) throws ServiceException, NoSingleResultException, DoesNotContainValueException, DatabaseException, AssumptionException, ValidationException, ManyObjectsForFunctionalRelationException {
        String exp;
        if (graph.isInstanceOf(r, ElementSelector.ES.Selector_All)) {
            exp = "all";
        } else if (graph.isInstanceOf(r, ElementSelector.ES.PropertySelector)) {
            Integer count = (Integer)graph.getRelatedValue(r, ElementSelector.ES.PropertySelector_HasResultCount);
            exp = count.toString();
        } else {
            throw new DatabaseException("Unsupported selector resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
        }
        Resource mapping = graph.getPossibleObject(r, ElementSelector.ES.Selector_HasMapping);
        if (mapping != null) {
            String name = (String)graph.getRelatedValue2(mapping, ElementSelector.L0.HasName);
            exp = String.valueOf(exp) + " " + name;
        } else {
            exp = String.valueOf(exp) + " elements";
        }
        if (graph.isInstanceOf(r, ElementSelector.ES.PropertySelector)) {
            String op;
            if (graph.isInstanceOf(r, ElementSelector.ES.Selector_NLowest)) {
                op = "lowest";
            } else if (graph.isInstanceOf(r, ElementSelector.ES.Selector_NHighest)) {
                op = "highest";
            } else {
                throw new DatabaseException("Unsupported property selector resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
            }
            String name = (String)graph.getRelatedValue(r, ElementSelector.ES.PropertySelector_HasSelectionPropertyName);
            exp = String.valueOf(exp) + " with " + op + " " + name;
        }
        return exp;
    }

    private static String buildConditionExpression(ReadGraph graph, Resource r) throws ServiceException, DatabaseException, NoSingleResultException, ManyObjectsForFunctionalRelationException, DoesNotContainValueException, AssumptionException, ValidationException {
        String result;
        boolean isInverse = graph.hasStatement(r, ElementSelector.ES.Condition_IsInverse, r);
        if (graph.isInstanceOf(r, ElementSelector.ES.PropertyCondition)) {
            result = ElementSelector.buildPropertyConditionExpression(graph, r);
        } else if (graph.isInstanceOf(r, ElementSelector.ES.RegionCondition)) {
            result = ElementSelector.buildRegionConditionExpression(graph, r);
        } else if (graph.isInstanceOf(r, ElementSelector.ES.RouteCondition)) {
            result = ElementSelector.buildRouteConditionExpression(graph, r);
        } else {
            if (graph.isInstanceOf(r, ElementSelector.ES.AggregateCondition)) {
                return ElementSelector.buildAggregateConditionExpression(graph, r, isInverse);
            }
            throw new DatabaseException("Unsupported condition resource type <" + graph.getURI(graph.getSingleType(r)) + ">");
        }
        if (isInverse) {
            result = "not {" + result + "}";
        }
        return result;
    }

    private static String buildAggregateConditionExpression(ReadGraph graph, Resource r, boolean isInverse) throws ServiceException, DatabaseException {
        String op = graph.isInstanceOf(r, ElementSelector.ES.Conjunction) ? " and " : " or ";
        ArrayList<String> exps = new ArrayList<String>();
        Collection objects = graph.getObjects(r, ElementSelector.ES.HasSubcondition);
        for (Resource c : objects) {
            String exp = ElementSelector.getExpression((RequestProcessor)graph, c);
            exps.add(objects.size() > 1 ? "{" + exp + "}" : exp);
        }
        String result = String.join((CharSequence)op, exps);
        if (graph.isInstanceOf(r, ElementSelector.ES.Negation) ^ isInverse) {
            result = "not {" + result + "}";
        }
        return result;
    }

    private static String buildRouteConditionExpression(ReadGraph graph, Resource r) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException, DoesNotContainValueException {
        Resource route = graph.getSingleObject(r, ElementSelector.ES.RouteCondition_HasRoute);
        String name = (String)graph.getRelatedValue(route, ElementSelector.L0.HasLabel);
        String result = "in route " + name;
        return result;
    }

    private static String buildRegionConditionExpression(ReadGraph graph, Resource r) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException, DoesNotContainValueException {
        Resource region = graph.getSingleObject(r, ElementSelector.ES.RegionCondition_HasRegion);
        String name = (String)graph.getRelatedValue(region, ElementSelector.L0.HasLabel);
        String result = "in region " + name;
        return result;
    }

    private static String buildPropertyConditionExpression(ReadGraph graph, Resource r) throws DatabaseException {
        String propertyName = (String)graph.getRelatedValue(r, ElementSelector.ES.PropertyCondition_HasPropertyName);
        Double lowerLimit = (Double)graph.getPossibleRelatedValue(r, ElementSelector.ES.PropertyCondition_HasLowerLimit);
        Double upperLimit = (Double)graph.getPossibleRelatedValue(r, ElementSelector.ES.PropertyCondition_HasUpperLimit);
        if (upperLimit == null) {
            if (lowerLimit == null) {
                return "has property " + propertyName;
            }
            return String.valueOf(propertyName) + " \u2265 " + lowerLimit;
        }
        StringBuilder result = new StringBuilder();
        if (lowerLimit != null) {
            result.append(lowerLimit);
            result.append(" \u2264 ");
        }
        result.append(propertyName);
        result.append(" \u2264 ");
        result.append(upperLimit);
        return result.toString();
    }

    private static Collection<Resource> elementsOfDiagram(ReadGraph graph, Resource diagram) throws DatabaseException {
        if (graph.isInstanceOf(diagram, ElementSelector.STR.Composite)) {
            return ElementSelector.elementsOfDiagram(graph, graph.getSingleObject(diagram, ElementSelector.MOD.CompositeToDiagram));
        }
        Collection elements = graph.getObjects(diagram, ElementSelector.L0.ConsistsOf);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : elements) {
            if (!graph.isInstanceOf(r, ElementSelector.DIA.Element)) continue;
            result.add(r);
        }
        return result;
    }

    private Collection<Resource> filterElementsFrom(ReadGraph graph, Collection<Resource> elements) throws DatabaseException {
        if (this.condition == null) {
            return elements;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : elements) {
            if (!this.condition.match(graph, r)) continue;
            result.add(r);
        }
        return result;
    }

    private SelectionResult gather(ReadGraph graph, Resource model) throws DatabaseException {
        return this.selector.select(graph, this.filterElementsFrom(graph, this.generator.generate(graph, model)));
    }

    public static class AggregateCondition
    extends Condition {
        public Type type;
        public List<Condition> conditions;

        public AggregateCondition(Resource r, Type type, List<Condition> conditions) {
            super(r);
            this.type = type;
            this.conditions = conditions;
        }

        public AggregateCondition(ReadGraph graph, Resource r) throws DatabaseException {
            super(graph, r);
            Collection conditionResources = graph.getObjects(this.resource, ElementSelector.ES.HasSubcondition);
            this.conditions = new ArrayList<Condition>(conditionResources.size());
            for (Resource c : conditionResources) {
                this.conditions.add(ElementSelector.buildCondition(graph, c));
            }
            if (graph.isInstanceOf(this.resource, ElementSelector.ES.Conjunction)) {
                this.type = Type.CONJUNCTION;
            } else if (graph.isInstanceOf(this.resource, ElementSelector.ES.Negation)) {
                this.type = Type.NEGATION;
            } else if (graph.isInstanceOf(this.resource, ElementSelector.ES.Disjunction)) {
                this.type = Type.DISJUNCTION;
            } else {
                throw new IllegalArgumentException("Unknown aggreate condition type " + graph.getURI(graph.getSingleType(this.resource)));
            }
        }

        @Override
        public boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            return this.doMatch(graph, r) ^ this.isInverse;
        }

        private boolean doMatch(ReadGraph graph, Resource r) throws DatabaseException {
            switch (this.type) {
                case DISJUNCTION: {
                    for (Condition c : this.conditions) {
                        if (!c.match(graph, r)) continue;
                        return true;
                    }
                    return false;
                }
                case CONJUNCTION: {
                    for (Condition c : this.conditions) {
                        if (c.match(graph, r)) continue;
                        return false;
                    }
                    return true;
                }
                case NEGATION: {
                    for (Condition c : this.conditions) {
                        if (!c.match(graph, r)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new IllegalArgumentException("Unknown aggregate condition type " + (Object)((Object)this.type));
        }

        @Override
        public Resource update(WriteGraph graph) throws DatabaseException {
            Resource type;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            if (this.resource == null) {
                this.resource = graph.newResource();
            } else {
                graph.deny(this.resource, L0.InstanceOf);
                graph.deny(this.resource, ES.HasSubcondition);
            }
            switch (this.type) {
                case CONJUNCTION: {
                    type = ES.Conjunction;
                    break;
                }
                case DISJUNCTION: {
                    type = ES.Disjunction;
                    break;
                }
                case NEGATION: {
                    type = ES.Negation;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown condition type " + (Object)((Object)this.type));
                }
            }
            graph.claim(this.resource, L0.InstanceOf, type);
            super.update(graph);
            for (Condition c : this.conditions) {
                graph.claim(this.resource, ES.HasSubcondition, c.update(graph));
            }
            return this.resource;
        }

        public static enum Type {
            DISJUNCTION,
            CONJUNCTION,
            NEGATION;

        }
    }

    public static class All
    extends Selector {
        @Override
        SelectionResult select(ReadGraph graph, Collection<Resource> elements) {
            Collection<Resource> selected = this.filterElements(graph, elements);
            return new SelectionResult(selected, 0, 0);
        }
    }

    public static abstract class Condition {
        public Resource resource;
        public boolean isInverse;

        Condition(Resource r) {
            this.resource = r;
            this.isInverse = false;
        }

        Condition(ReadGraph graph, Resource r) throws DatabaseException {
            this(r);
            ElementSelectionResource ES = ElementSelectionResource.getInstance(graph);
            this.isInverse = graph.hasStatement(r, ES.Condition_IsInverse, r);
        }

        public abstract boolean match(ReadGraph var1, Resource var2) throws DatabaseException;

        public Resource update(WriteGraph graph) throws DatabaseException {
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            assert (this.resource != null);
            if (this.isInverse) {
                graph.claim(this.resource, ES.Condition_IsInverse, this.resource);
            } else {
                graph.deny(this.resource, ES.Condition_IsInverse, this.resource);
            }
            return this.resource;
        }
    }

    public static class DiagramGenerator
    extends Generator {
        public Resource diagram;

        public DiagramGenerator(Resource diagram) {
            this.diagram = diagram;
        }

        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) throws DatabaseException {
            return ElementSelector.elementsOfDiagram(graph, this.diagram);
        }
    }

    public static class ElementSelectorQuery
    extends ResourceRead<ElementSelector> {
        public ElementSelectorQuery(Resource resource) {
            super(resource);
        }

        public ElementSelector perform(ReadGraph graph) throws DatabaseException {
            return new ElementSelector(graph, this.resource);
        }
    }

    public static class ExplicitGenerator
    extends Generator {
        public Collection<Resource> elements;

        public ExplicitGenerator(Collection<Resource> elements) {
            this.elements = elements;
        }

        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) {
            return this.elements;
        }
    }

    public static abstract class Generator {
        abstract Collection<Resource> generate(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    public static class ModelGenerator
    extends Generator {
        @Override
        Collection<Resource> generate(ReadGraph graph, Resource model) throws DatabaseException {
            Resource conf = (Resource)graph.syncRequest((Read)new Configuration(model));
            HashMap<Resource, Resource> fromMapped = new HashMap<Resource, Resource>();
            for (Resource comp : graph.getObjects(conf, ElementSelector.L0.ConsistsOf)) {
                Resource diagram;
                if (!graph.isInstanceOf(comp, ElementSelector.STR.Composite) || (diagram = graph.getPossibleObject(comp, ElementSelector.MOD.CompositeToDiagram)) == null) continue;
                for (Resource elem : ElementSelector.elementsOfDiagram(graph, diagram)) {
                    Resource mapped = graph.getPossibleObject(elem, ElementSelector.DN.MappedComponent);
                    if (mapped != null) {
                        fromMapped.put(mapped, elem);
                        continue;
                    }
                    if (fromMapped.containsKey(elem)) continue;
                    fromMapped.put(elem, elem);
                }
            }
            return new ArrayList<Resource>(fromMapped.values());
        }
    }

    public static class PropertyCondition
    extends Condition {
        public String propertyName;
        public Double lowerLimit;
        public Double upperLimit;

        public PropertyCondition(ReadGraph graph, Resource r) throws DatabaseException {
            super(graph, r);
            ElementSelectionResource ES = ElementSelectionResource.getInstance(graph);
            this.propertyName = (String)graph.getRelatedValue(this.resource, ES.PropertyCondition_HasPropertyName);
            this.lowerLimit = (Double)graph.getPossibleRelatedValue(this.resource, ES.PropertyCondition_HasLowerLimit);
            this.upperLimit = (Double)graph.getPossibleRelatedValue(this.resource, ES.PropertyCondition_HasUpperLimit);
        }

        public PropertyCondition(Resource r, String propertyName, Double lowerLimit, Double upperLimit) {
            super(r);
            this.propertyName = propertyName;
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        public boolean match(ReadGraph graph, Resource r) {
            Double value = ElementSelector.getPropertyValue(graph, r, this.propertyName);
            boolean result = value != null && (this.lowerLimit == null || value >= this.lowerLimit) && (this.upperLimit == null || value <= this.upperLimit);
            return result ^ this.isInverse;
        }

        @Override
        public Resource update(WriteGraph graph) throws DatabaseException {
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (this.resource == null) {
                this.resource = graph.newResource();
                graph.claim(this.resource, L0.InstanceOf, ES.PropertyCondition);
            }
            super.update(graph);
            graph.claimLiteral(this.resource, ES.PropertyCondition_HasPropertyName, (Object)this.propertyName);
            if (this.lowerLimit != null) {
                graph.claimLiteral(this.resource, ES.PropertyCondition_HasLowerLimit, L0.Double, (Object)this.lowerLimit);
            } else {
                graph.deny(this.resource, ES.PropertyCondition_HasLowerLimit);
            }
            if (this.upperLimit != null) {
                graph.claimLiteral(this.resource, ES.PropertyCondition_HasUpperLimit, L0.Double, (Object)this.upperLimit);
            } else {
                graph.deny(this.resource, ES.PropertyCondition_HasUpperLimit);
            }
            return this.resource;
        }
    }

    public static class PropertySelector
    extends Selector {
        public boolean smallest;
        public String propertyName;
        public int resultCount;

        public PropertySelector(boolean smallest, String propertyName, int resultCount) {
            this.smallest = smallest;
            this.propertyName = propertyName;
            this.resultCount = resultCount;
        }

        public PropertySelector(ReadGraph graph, Resource resource) throws DatabaseException {
            this.propertyName = (String)graph.getRelatedValue(resource, ElementSelector.ES.PropertySelector_HasSelectionPropertyName);
            this.resultCount = (Integer)graph.getRelatedValue(resource, ElementSelector.ES.PropertySelector_HasResultCount);
            this.smallest = graph.isInstanceOf(resource, ElementSelector.ES.Selector_NLowest);
        }

        @Override
        SelectionResult select(ReadGraph graph, Collection<Resource> elements) {
            elements = this.filterElements(graph, elements);
            Comparator comparator = this.smallest ? (p1, p2) -> Double.compare((Double)p1.second, (Double)p2.second) : (p1, p2) -> Double.compare((Double)p2.second, (Double)p1.second);
            List result2 = elements.stream().map(r -> Pair.make((Object)r, (Object)ElementSelector.getPropertyValue(graph, r, this.propertyName))).filter(t -> t.second != null).sorted(comparator).collect(Collectors.toList());
            int count = Math.min(this.resultCount, result2.size());
            int tailCount = 0;
            double tailValue = count > 0 ? (Double)((Pair)result2.get((int)(count - 1))).second : 0.0;
            int i = count - 1;
            while (i >= 0) {
                if ((Double)((Pair)result2.get((int)i)).second != tailValue) break;
                ++tailCount;
                --i;
            }
            int tailSize = tailCount;
            int i2 = count;
            while (i2 < result2.size()) {
                if ((Double)((Pair)result2.get((int)i2)).second != tailValue) break;
                ++tailSize;
                ++i2;
            }
            if (count < result2.size()) {
                result2 = result2.subList(0, this.resultCount);
            }
            List<Resource> selection = result2.stream().map(p -> (Resource)p.first).collect(Collectors.toList());
            return new SelectionResult(selection, tailCount, tailSize);
        }
    }

    public static class RegionCondition
    extends Condition {
        public Resource regionResource;
        double[] region;
        Path2D path;

        public RegionCondition(Resource r, Resource regionResource, double[] region) {
            super(r);
            this.region = region;
            this.path = RegionCondition.createPathForRegion(region);
            this.regionResource = regionResource;
        }

        public RegionCondition(ReadGraph graph, Resource r) throws DatabaseException {
            super(graph, r);
            ElementSelectionResource ES = ElementSelectionResource.getInstance(graph);
            DiagramRegionsResource DR = DiagramRegionsResource.getInstance((ReadGraph)graph);
            this.regionResource = graph.getPossibleObject(this.resource, ES.RegionCondition_HasRegion);
            this.region = this.regionResource != null ? (double[])graph.getRelatedValue(this.regionResource, DR.Region_area) : null;
            this.path = RegionCondition.createPathForRegion(this.region);
        }

        public static Path2D createPathForRegion(double[] region) {
            Path2D.Double path = new Path2D.Double();
            if (region != null) {
                double startX = region[0];
                double startY = region[1];
                ((Path2D)path).moveTo(startX, startY);
                int i = 2;
                while (i < region.length) {
                    ((Path2D)path).lineTo(region[i], region[i + 1]);
                    i += 2;
                }
                path.closePath();
            }
            return path;
        }

        @Override
        public boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            double[] transform = (double[])graph.getRelatedValue(r, ElementSelector.DIA.HasTransform);
            double x = transform[4];
            double y = transform[5];
            return this.path.contains(x, y) ^ this.isInverse;
        }

        @Override
        public Resource update(WriteGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            DiagramRegionsResource DR = DiagramRegionsResource.getInstance((ReadGraph)graph);
            if (this.resource == null) {
                this.resource = graph.newResource();
                graph.claim(this.resource, L0.InstanceOf, ES.RegionCondition);
            }
            super.update(graph);
            graph.claim(this.resource, ES.RegionCondition_HasRegion, this.regionResource);
            this.region = this.regionResource != null ? (double[])graph.getRelatedValue(this.regionResource, DR.Region_area, (Binding)Bindings.DOUBLE_ARRAY) : null;
            this.path = RegionCondition.createPathForRegion(this.region);
            return this.resource;
        }
    }

    public static class RouteCondition
    extends Condition {
        public Resource routeResource;
        Set<Resource> routePoints;

        public RouteCondition(Resource r, Resource routeResource, Set<Resource> routePoints) {
            super(r);
            this.routePoints = routePoints;
            this.routeResource = routeResource;
        }

        public RouteCondition(ReadGraph graph, Resource r) throws DatabaseException {
            super(graph, r);
            this.routeResource = graph.getPossibleObject(this.resource, ElementSelector.ES.RouteCondition_HasRoute);
            this.routePoints = RouteCondition.getRoutePoints(graph, this.routeResource);
        }

        public static Set<Resource> getRoutePoints(ReadGraph graph, Resource routeResource) throws DatabaseException {
            return routeResource != null ? new HashSet(ListUtils.toList((ReadGraph)graph, (Resource)routeResource)) : Collections.emptySet();
        }

        @Override
        public boolean match(ReadGraph graph, Resource r) throws DatabaseException {
            return this.routePoints.contains(r) ^ this.isInverse;
        }

        @Override
        public Resource update(WriteGraph graph) throws DatabaseException {
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (this.resource == null) {
                this.resource = graph.newResource();
                graph.claim(this.resource, L0.InstanceOf, ES.RouteCondition);
            }
            super.update(graph);
            if (this.routeResource != null) {
                graph.claim(this.resource, ES.RouteCondition_HasRoute, this.routeResource);
            }
            this.routePoints = RouteCondition.getRoutePoints((ReadGraph)graph, this.routeResource);
            return this.resource;
        }
    }

    public static final class SelectionConditionRequest
    extends ResourceRead<Condition> {
        public SelectionConditionRequest(Resource resource) {
            super(resource);
        }

        public Condition perform(ReadGraph graph) throws DatabaseException {
            return ElementSelector.buildCondition(graph, this.resource);
        }
    }

    public static final class SelectionExpressionRequest
    extends ResourceRead<String> {
        public SelectionExpressionRequest(Resource condition) {
            super(condition);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            return ElementSelector.buildExpression(graph, this.resource);
        }
    }

    public static class SelectionResult {
        public final Collection<Resource> elements;
        public final int tailCount;
        public final int tailSize;

        public SelectionResult(Collection<Resource> elements, int tailCount, int tailSize) {
            this.elements = elements;
            this.tailCount = tailCount;
            this.tailSize = tailSize;
        }
    }

    public static abstract class Selector {
        public Resource componentType = null;

        abstract SelectionResult select(ReadGraph var1, Collection<Resource> var2);

        Collection<Resource> filterElements(ReadGraph graph, Collection<Resource> elements) {
            if (this.componentType == null) {
                return elements;
            }
            HashSet<Resource> selected = new HashSet<Resource>(elements.size());
            for (Resource r : elements) {
                try {
                    if (!graph.hasStatement(r, ElementSelector.DN.HasMapping, this.componentType)) continue;
                    selected.add(r);
                }
                catch (DatabaseException databaseException) {}
            }
            return selected;
        }
    }
}

