/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.techtype.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.district.network.ontology.DistrictNetworkResource;

public class EnableTechTypeItem
extends WriteRequest {
    Resource table;
    int itemIndex;
    boolean enable;

    public EnableTechTypeItem(Resource table, int itemIndex, boolean enable) {
        this.table = table;
        this.itemIndex = itemIndex;
        this.enable = enable;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        ArrayListBinding binding = new ArrayListBinding(Datatypes.INTEGER_ARRAY, (Binding)Bindings.INTEGER);
        List enabled = (List)graph.getPossibleRelatedValue2(this.table, DN.TechType_TechTypeTable_HasEnabledItems, (Binding)binding);
        if (enabled == null) {
            enabled = Collections.emptyList();
        }
        if (this.enable) {
            if (!enabled.contains(this.itemIndex)) {
                enabled = new ArrayList(enabled);
                enabled.add(this.itemIndex);
                graph.getSession().markUndoPoint();
                graph.claimLiteral(this.table, DN.TechType_TechTypeTable_HasEnabledItems, enabled, (Binding)binding);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Enable tech type table item " + (this.itemIndex + 1)));
            }
        } else if (enabled.contains(this.itemIndex)) {
            enabled = new ArrayList(enabled);
            enabled.remove((Object)this.itemIndex);
            graph.getSession().markUndoPoint();
            graph.claimLiteral(this.table, DN.TechType_TechTypeTable_HasEnabledItems, enabled, (Binding)binding);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Disable tech type table item " + (this.itemIndex + 1)));
        }
    }
}

