/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.changeset;

import java.util.Map;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependenciesRelation;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictChangeListener
extends GenericChangeListener<DependenciesRelation.DependencyChangesRequest, DependencyChanges> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictChangeListener.class);

    public void onEvent(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
        for (Map.Entry modelEntry : event.get().entrySet()) {
            DependencyChanges.Change[] changes;
            Resource model = (Resource)modelEntry.getKey();
            DependencyChanges.Change[] changeArray = changes = (DependencyChanges.Change[])modelEntry.getValue();
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyChanges.ComponentAddition entry;
                DependencyChanges.Change _entry = changeArray[n2];
                if (_entry instanceof DependencyChanges.ComponentAddition) {
                    entry = (DependencyChanges.ComponentAddition)_entry;
                    if (DistrictChangeListener.areWeInterested(graph, entry.component, entry.parent)) {
                        this.elementAddition(graph, entry.component);
                    }
                } else if (_entry instanceof DependencyChanges.ComponentModification) {
                    entry = (DependencyChanges.ComponentModification)_entry;
                    if (DistrictChangeListener.areWeInterested(graph, entry.component, graph.getPossibleObject(entry.component, Layer0.getInstance((ReadGraph)graph).PartOf))) {
                        this.elementModification(graph, entry.component);
                    }
                } else if (_entry instanceof DependencyChanges.ComponentRemoval) {
                    entry = (DependencyChanges.ComponentRemoval)_entry;
                    this.elementRemoved(graph, entry.component, entry.parent);
                } else {
                    boolean cfr_ignored_0 = _entry instanceof DependencyChanges.LinkChange;
                }
                ++n2;
            }
            this.changesInspected(graph, model);
        }
    }

    private static boolean areWeInterested(ReadGraph graph, Resource component, Resource parent) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Boolean trackChangesEnabled = false;
        if (parent != null && graph.isInstanceOf(parent, DN.Diagram)) {
            trackChangesEnabled = DistrictNetworkUtil.trackChangesEnabled(graph, parent);
        }
        return trackChangesEnabled != false && (graph.isInstanceOf(component, DN.Edge) || graph.isInstanceOf(component, DN.Vertex));
    }

    protected void elementAddition(ReadGraph graph, Resource element) throws DatabaseException {
    }

    protected void elementModification(ReadGraph graph, Resource element) throws DatabaseException {
    }

    protected void elementRemoved(ReadGraph graph, Resource element, Resource parent) throws DatabaseException {
    }

    protected void changesInspected(ReadGraph graph, Resource model) throws DatabaseException {
    }
}

