/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx.clipboard.streams;

import java.io.IOException;
import java.io.InputStream;

import org.simantics.utils.ui.gfx.clipboard.headers.BitmapInfoHeader;
import org.simantics.utils.ui.gfx.clipboard.headers.Win32Constants;


/**
 * <p>
 * Intended to uncompress compressed image streams so that 
 * SWT can use images sent to clipboard (native WIN32)
 * </p>
 * <p>
 * Currently no uncompression methods are implemented, so 
 * stream throws <code>IOException</code> if its used to 
 * stream compressed images.
 * </p>
 * 
 * @author Marko Luukkainen
 *
 */
public class UncompressedDIBInputStream extends InputStream {
    private InputStream iStream;
    private int readBytes = 0;
    private byte [] header;
    
    public UncompressedDIBInputStream(InputStream iStream) throws IOException{
        this.iStream = iStream;
        header = new byte[BitmapInfoHeader.sizeof];
        iStream.read(header, 0, BitmapInfoHeader.sizeof);
        
        BitmapInfoHeader infoHeader = new BitmapInfoHeader();
        infoHeader.setBytes(header);
        if (infoHeader.biCompression == Win32Constants.BI_BITFIELDS) {
            throw new IOException("BI_BITFIELDS stream not supported");
        }
        if (infoHeader.biCompression == Win32Constants.BI_JPEG) {
            throw new IOException("BI_JPEG stream not supported");
        }
        if (infoHeader.biCompression == Win32Constants.BI_PNG) {
            throw new IOException("BI_PNG stream not supported");
        }
        if (infoHeader.biCompression == Win32Constants.BI_RLE8) {
            throw new IOException("BI_RLE8 stream not supported");
        }
        if (infoHeader.biCompression == Win32Constants.BI_RLE24) {
            throw new IOException("BI_RLE24 stream not supported");
        }
    }
    
    @Override
    public int read() throws IOException {
        if (readBytes < header.length) {
            return 0xff & header[readBytes++];
        }
        return iStream.read();
    }
}
